@php
    $bread_crumb['page_main_bread_crumb'] = labels('front_messages.password_recovery', 'Password Recovery');
@endphp
<div class="{{ $isModal ? 'p-0' : '' }}" {{ $isModal ? '' : 'id=page-content' }}>
    @if(!$isModal)
    <x-utility.breadcrumbs.breadcrumbTwo :$bread_crumb />
    @endif
    <div class="{{ $isModal ? '' : 'container-fluid' }}">
        <div class="login-register {{ $isModal ? 'p-0' : '' }}">
            <div class="row">
                <div class="{{ $isModal ? 'col-12' : 'col-12 col-sm-12 col-md-8 offset-md-2 col-lg-6 offset-lg-3' }}">
                    <div class="inner h-100">
                        <h2 class="text-center fs-4 mb-3">
                            {{ labels('front_messages.forgot_password', 'Forgot Password') }}</h2>
                        <div class="send-otp-box">
                            <p class="text-center mb-4">{{ labels('front_messages.enter_mobile_number', 'Please enter your Mobile Number below.') }} {{ labels('front_messages.receive_otp', 'You will receive an OTP to verify your mobile number.') }}
                            </p>
                            <div class="form-row">
                                <div class="form-group col-12 mb-4 d-flex flex-column">
                                    <label for="number"
                                        class="d-none">{{ labels('front_messages.enter_your_mobile_number', 'Enter your Mobile Number') }}
                                        <span class="required">*</span></label>
                                    <div wire:ignore class="w-100">
                                        <input type="number" name="number" placeholder="Enter your Mobile Number"
                                            id="recovery_number" value="" required />
                                    </div>
                                    <div class="d-flex justify-content-center align-content-center my-2">
                                        <div id="recaptcha-container"></div>
                                    </div>
                                    <input type="hidden" name="type" id="type" value="password-recovery">
                                </div>
                                <div class="form-group col-12 mb-0">
                                    <div
                                        class="login-remember-forgot d-flex justify-content-between align-items-center">
                                        <input type="submit" id="send_otp" class="btn btn-primary btn-lg"
                                            value="{{ labels('front_messages.password_reset', 'Password Reset') }}" />
                                        <a href="{{ $isModal ? 'javascript:void(0)' : customUrl('login') }}" 
                                            @if($isModal) data-bs-toggle="modal" data-bs-target="#loginModal" @else wire:navigate @endif
                                            class="d-flex-justify-center btn-link">
                                            <ion-icon name="chevron-back-outline" class="me-1"></ion-icon>
                                            {{ labels('front_messages.back_to_login', 'Back to Login') }}</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="verify-otp-box d-none">
                            <div class="form-row">
                                <div class="form-group col-12 mb-4 d-flex flex-column">
                                    <label for="number"
                                        class="d-none">{{ labels('front_messages.enter_verification_code', 'Enter Verification Code You have Received') }}<span
                                            class="required">*</span></label>
                                    <input type="number" name="verificationCode" placeholder="Verification Code"
                                        id="verificationCode" value="" required />
                                    <input type="hidden" name="type" id="type" value="password-recovery">
                                </div>
                                <div class="form-group col-12 mb-0">
                                    <div
                                        class="login-remember-forgot d-flex justify-content-between align-items-center">
                                        <input type="submit" id="verify_otp" class="btn btn-primary btn-lg"
                                            value="Verify Otp" />
                                    </div>
                                </div>
                            </div>
                        </div>
                        <form class="reset-password-form d-none" method="POST"
                            action="{{ url('password-recovery/set-new-password') }}">
                            <p class="text-center mb-4">
                                {{ labels('front_messages.enter_new_password', 'Please enter New Password') }}</p>
                            <div class="form-row">
                                <div class="form-group col-12 mb-4 d-flex flex-column">
                                    <div class="form-group col-12">
                                        <label for="recovery_new_password"
                                            class="d-none">{{ labels('front_messages.password', 'Password') }}
                                            <span class="required">*</span></label>
                                            
                                        <input type="password" name="recovery_new_password" placeholder="Password" id="recovery_new_password"
                                           />
                                            <ion-icon name="eye-off-outline" class="eye-icon toggle-password"></ion-icon>

                                    </div>
                                    <div class="form-group col-12">
                                        <label for="recovery_verify_password"
                                            class="d-none">{{ labels('front_messages.confirm_password', 'Confirm Password') }}
                                            <span class="required">*</span></label>
                                        <input type="password" id="recovery_verify_password" name="recovery_verify_password"
                                            placeholder="Confirm Password"  autocomplete="new-password"/>
                                            <ion-icon name="eye-off-outline" class="eye-icon toggle-password"></ion-icon>

                                    </div>
                                    <input type="hidden" name="type" class="type" value="password-recovery">
                                </div>
                                <div class="form-group col-12 mb-0">
                                    <div
                                        class="login-remember-forgot d-flex justify-content-between align-items-center">
                                        <input type="submit" id="changePassword" class="btn btn-primary btn-lg"
                                            value="Change Password" />
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                    <input type="hidden" name="authentication_method" id="authentication_method"
                        value="{{ $authentication_method }}">
                </div>
            </div>
        </div>
    </div>
</div>
<script>
/* 🔐 Show / Hide Password */
$(document).on("click", ".toggle-password", function () {
    let input = $(this).siblings("input");
    let type = input.attr("type") === "password" ? "text" : "password";
    input.attr("type", type);

    $(this).attr(
        "name",
        type === "password" ? "eye-off-outline" : "eye-outline"
    );
});

/* 🔄 Reset form when Forgot Password modal is closed */
$(document).on('hidden.bs.modal', '#forgotPasswordModal', function () {
    // 1. Reset Livewire state (prevents UI change by keeping isModal true)
    if (typeof Livewire !== 'undefined') {
        Livewire.dispatch('resetForgetPasswordForm');
    }
    
    // 2. Clear all input values
    const $modal = $(this);
    $modal.find('input[type="number"], input[type="text"], input[type="password"]').val('');
    
    // Explicitly reset intlTelInput if it exists
    const recoveryNumber = document.querySelector("#recovery_number");
    if (recoveryNumber && typeof window.intlTelInputGlobals !== 'undefined') {
        const iti = window.intlTelInputGlobals.getInstance(recoveryNumber);
        if (iti) {
            iti.setNumber(""); // This clears the input and resets the flag if needed
        }
    }

    // 3. Reset UI visibility to Step 1 (Mobile Number)
    $modal.find('.send-otp-box').removeClass('d-none').show();
    $modal.find('.verify-otp-box, .reset-password-form').addClass('d-none').hide();

    // 4. Reset Button states (Clear loading/disabled states)
    const $sendBtn = $modal.find('#send_otp');
    $sendBtn.prop('disabled', false).val("{{ labels('front_messages.password_reset', 'Password Reset') }}");
    
    const $verifyBtn = $modal.find('#verify_otp');
    $verifyBtn.prop('disabled', false).val("Verify Otp");
    
    const $changeBtn = $modal.find('#changePassword');
    $changeBtn.prop('disabled', false).val("Change Password");

    // 5. Reset Password eye icons & field types
    $modal.find('.toggle-password').each(function() {
        $(this).attr('name', 'eye-off-outline');
        const $input = $(this).siblings('input');
        if ($input.length) { $input.attr('type', 'password'); }
    });
});
</script>
