@php
$bread_crumb['page_main_bread_crumb'] = labels('front_messages.sign_in', 'Login');
@endphp
<div  class="{{ $isModal ? 'p-0' : '' }}">
    @if (!$isModal)
    <x-utility.breadcrumbs.breadcrumbTwo :$bread_crumb />
    @endif
    <div class="{{ $isModal ? '' : 'container-fluid' }}">
        <div class="login-register {{ $isModal ? 'p-0' : 'pt-2' }}">
            <div class="row">
                <div class="{{ $isModal ? 'col-12' : 'col-12 col-sm-12 col-md-8 offset-md-2 col-lg-6 offset-lg-3' }}">
                    <div class="inner h-100 position-relative">
                        <form wire:submit="login" class="customer-form" wire:loading.attr="disabled">
                            <h2 class="text-center fs-4 mb-3">
                                {{ labels('front_messages.sign_in', 'Login') }}
                            </h2>
                            <p class="text-center mb-4">
                                {{ labels('front_messages.if_you_have_an_account_with_us_please_log_in', 'If you have an account with us, please Login.') }}
                            </p>
                            <div class="form-row justify-content-around">
                                @if ($errors->has('loginError'))
                                <p class="fw-400 text-danger mt-1">{{ $errors->first('loginError') }}</p>
                                @endif
                                <div class="form-group col-12">
                                    <label for="mobile"
                                        class="d-none">{{ labels('front_messages.mobile_number', 'Mobile Number') }}
                                        <span class="required">*</span></label>
                                    <div wire:ignore>
                                        <input wire:model="mobile" type="number" name="mobile"
                                            placeholder="{{ labels('front_messages.mobile_number', 'Mobile Number') }} "
                                            id="mobile" value="" />
                                    </div>
                                    @error('mobile')
                                    <p class="fw-400 text-danger mt-1">{{ $message }}</p>
                                    @enderror
                                </div>
                                <div class="form-group col-12">
                                    <label for="password"
                                        class="d-none">{{ labels('front_messages.password', 'Password') }}
                                        <span class="required">*</span></label>
                                    <input wire:model="password" type="password" name="password"
                                        placeholder="{{ labels('front_messages.password', 'Password') }}" id="password"
                                        value="" />
                                    <span wire:ignore>
                                        <ion-icon name="eye-off-outline" class="eye-icon"></ion-icon>
                                    </span>
                                    @error('password')
                                    <p class="fw-400 text-danger mt-1">{{ $message }}</p>
                                    @enderror
                                </div>
                                {{-- 
                                    <!-- captcha  -->
                                 <div class="form-group col-12 mb-3">
                                    <label for="captcha" class="mb-1">{{ labels('front_messages.enter_captcha', 'Enter Captcha') }} <span class="required">*</span></label>
                                    <div class="captcha-wrapper d-flex flex-column gap-2 p-3 border rounded" style="background: #fdfdfd; border-color: #eee !important;">
                                        <div class="d-flex align-items-center gap-2">
                                            <div id="login-captcha-img-container">
                                                {!! captcha_img('flat') !!}
                                            </div>
                                            <button type="button" class="btn btn-outline-secondary btn-sm d-flex align-items-center justify-content-center" 
                                                wire:click="refreshCaptcha" 
                                                style="height: 35px; width: 35px; min-width: 35px; padding: 0;"
                                                title="Refresh Captcha">
                                                <span wire:ignore>
                                                    <ion-icon name="refresh-outline" style="font-size: 20px;"></ion-icon>
                                                </span>
                                            </button>
                                        </div>
                                        <input wire:model="captcha" type="text" id="login_captcha_input" 
                                            class="form-control mt-1" 
                                            placeholder="Type the code shown above" 
                                            autocomplete="off"
                                            style="height: 40px !important;">
                                        @error('captcha')
                                            <p class="fw-400 text-danger mt-1 mb-0" style="font-size: 13px;">{{ $message }}</p>
                                        @enderror
                                    </div>
                                 </div>
                                 --}}
                                <div class="form-group col-12">
                                    <div
                                        class="login-remember-forgot d-flex justify-content-between align-items-center">
                                        <div class="remember-check customCheckbox">
                                            <input id="remember" name="remember" type="checkbox" value="remember" />
                                            <label
                                                for="remember">{{ labels('front_messages.remember_me', 'Remember me') }}
                                            </label>
                                        </div>
                                        <a href="{{ $isModal ? 'javascript:void(0)' : customUrl('password-recovery') }}" 
                                            @if($isModal) data-bs-toggle="modal" data-bs-target="#forgotPasswordModal" @else wire:navigate @endif>
                                            {{ labels('front_messages.forgot_password', 'Forgot your password?') }}
                                        </a>
                                    </div>
                                </div>
                                <div class="form-group col-12 mb-0">
                                    <button type="submit"
                                        id="login-submit-btn"
                                        class="btn btn-primary btn-lg w-100 sign-in d-flex justify-content-center align-items-center gap-2"
                                        wire:loading.attr="disabled"
                                        wire:target="login"
                                        wire:loading.class="btn-primary"
                                        wire:loading.class.remove="btn-primary">

                                        <span>{{ labels('front_messages.sign_in', 'Login') }}</span>

                                        <span class="spinner-border spinner-border-sm ms-1"
                                            role="status"
                                            aria-hidden="true"
                                            wire:loading.inline
                                            wire:target="login"></span>

                                    </button>

                                </div>
                            </div>
                        </form>
                        @if ($system_settings['google'] == 1 || $system_settings['facebook'] == 1)
                        {{-- <div class="login-divide"><span
                                    class="login-divide-text">{{ labels('front_messages.or', 'OR') }}</span>
                    </div> --}}

                    {{-- <p class="text-center fs-6 text-muted mb-3">
                                {{ labels('front_messages.sign_in_with_social_account', 'Login in with social account') }}
                    </p>
                    <div class="login-social d-flex-justify-center">
                        @if ($system_settings['facebook'] == 1)
                        <a class="social-link facebook rounded-5 d-flex-justify-center"
                            href="{{ url('auth/facebook') }}">
                            <i class="anm anm-facebook hdr-icon icon me-2"></i></ion-icon>
                            {{ labels('front_messages.facebook', 'Facebook') }}</a>
                        @endif
                        @if ($system_settings['google'] == 1)
                        <a class="social-link google rounded-5 d-flex-justify-center"
                            href="{{ url('auth/google') }}"><i
                                class="anm anm-google hdr-icon icon me-2"></i>
                            {{ labels('front_messages.google', 'Google') }}</a>
                        @endif
                    </div> --}}
                    @endif
                    <div class="login-signup-text mt-4 mb-2 fs-6 text-center text-muted">
                        Don't have account?
                        <a href="{{ $isModal ? 'javascript:void(0)' : customUrl('register') }}" @if($isModal) data-bs-toggle="modal" data-bs-target="#registerModal" @else wire:navigate @endif
                            class="btn-link">{{ labels('front_messages.sign_up_now', 'Register now') }}</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!--End Main Content-->
<script>
    // Refresh captcha
    window.addEventListener('refreshCaptcha', event => {
        fetch('/captcha/flat?' + Math.random())
            .then(response => response.url)
            .then(url => {
                const container = document.getElementById('login-captcha-img-container');
                if (container) {
                    const img = container.querySelector('img');
                    if (img) img.src = url;
                }
            });
    });

    // Toggle password visibility (Robust Version)
    document.addEventListener('click', function(e) {
        const eyeIcon = e.target.closest('.eye-icon');
        if (eyeIcon && (eyeIcon.tagName === 'ION-ICON' || eyeIcon.classList.contains('eye-icon'))) {
            // Find input in the same form-group
            const passwordInput = eyeIcon.closest('.form-group')?.querySelector('input');
            
            if (passwordInput) {
                if (passwordInput.type === 'password') {
                    passwordInput.type = 'text';
                    eyeIcon.setAttribute('name', 'eye-outline');
                } else {
                    passwordInput.type = 'password';
                    eyeIcon.setAttribute('name', 'eye-off-outline');
                }
            }
        }
    });

    // Ensure eye icons have pointer cursor
    document.addEventListener('DOMContentLoaded', function() {
        const style = document.createElement('style');
        style.innerHTML = '.eye-icon { cursor: pointer; }';
        document.head.appendChild(style);
    });

    // Reset form when modal is closed
    document.addEventListener('DOMContentLoaded', function() {
        const loginModal = document.getElementById('loginModal');
        if (loginModal) {
            loginModal.addEventListener('hidden.bs.modal', function () {
                // Trigger Livewire reset method
                Livewire.dispatch('resetLoginForm');
                
                // Manually clear inputs with wire:ignore
                const mobileInput = loginModal.querySelector('#mobile');
                if (mobileInput) mobileInput.value = '';
                
                // Reset all password fields and icons in this modal
                loginModal.querySelectorAll('input[type="text"]').forEach(input => {
                    const icon = input.closest('.form-group')?.querySelector('.eye-icon');
                    if (icon) {
                        input.type = 'password';
                        icon.setAttribute('name', 'eye-off-outline');
                        icon.name = 'eye-off-outline';
                    }
                });
            });
        }
    });
</script>
</div>
