@php
    use App\Services\StoreService;
    $store_settings = app(StoreService::class)->getStoreSettings();
    $component = getProductDisplayComponent($store_settings);
@endphp

<div class="grid-products grid-view-items mb-4">
    <div class="row col-row text-center product-options {{ ($store_settings['products_display_style_for_web'] ?? '') == 'products_display_style_for_web_3' ? 'pro-hover3' : '' }} row-cols-lg-4 row-cols-md-3 row-cols-sm-3 row-cols-2">
        @forelse($products as $product)
            @php($details = (object) $product)
            <x-dynamic-component :component="$component" :details="$details" />
        @empty
            <div class="col-12 text-center">
                <div class="text-center py-4">No products found for this category.</div>
            </div>
        @endforelse
    </div>
</div>

