<?php
    // dd(count($products_listing) < 1);
    // dd(count($Attributes) >= 1 && count($products_listing) < 1);
    $showFilter = true;
    use App\Models\Brand;
    use App\Services\TranslationService;
    use App\Services\StoreService;
    use App\Services\MediaService;
    use App\Services\CurrencyService;

    // Custom Sort options
    $sortByOptions = [
        '' => labels('front_messages.featured', 'Featured'),
        'top-rated' => labels('front_messages.top_rated', 'Top Rated'),
        'price-asc' => labels('front_messages.price_low_to_high', 'Price, low to high'),
        'price-desc' => labels('front_messages.price_high_to_low', 'Price, high to low'),
        'oldest-first' => labels('front_messages.old_to_new', 'Old to New'),
        'latest-products' => labels('front_messages.new_to_old', 'New to Old'),
    ];
    $currentSortLabel = $sortByOptions[$sorted_by] ?? $sortByOptions[''];
?>

<style>
    /* Custom List-based Dropdown Styles for Sort By */
    .custom-toolbar-dropdown {
        position: relative;
        display: inline-block;
    }
    .custom-toolbar-dropdown .dropdown-toggle {
        padding: 5px 12px;
        border: 1px solid #ddd;
        background: #fff;
        cursor: pointer;
        display: flex;
        align-items: center;
        min-width: 150px;
        justify-content: space-between;
        font-size: 14px;
        border-radius: 4px;
        color: #333;
    }
    .custom-toolbar-dropdown .dropdown-list {
        position: absolute;
        top: 100%;
        right: 0;
        background: #fff;
        border: 1px solid #ddd;
        border-radius: 4px;
        box-shadow: 0 4px 12px rgba(0,0,0,0.1);
        z-index: 1060;
        display: none;
        min-width: 180px;
        overflow: visible; /* Changed from hidden to allow pseudo-element bridge */
    }
    /* Bridge the gap between toggle and list to maintain hover state */
    .custom-toolbar-dropdown .dropdown-list::before {
        content: '';
        position: absolute;
        top: -10px;
        left: 0;
        width: 100%;
        height: 10px;
        background: transparent;
    }
    .custom-toolbar-dropdown:hover .dropdown-list {
        display: block;
    }
    .custom-toolbar-dropdown .dropdown-list ul {
        list-style: none !important;
        margin: 0 !important;
        padding: 5px 0 !important;
    }
    .custom-toolbar-dropdown .dropdown-list ul li {
        margin: 0 !important;
        padding: 0 !important;
        list-style: none !important;
    }
    .custom-toolbar-dropdown .dropdown-list ul li a {
        display: block;
        padding: 8px 15px;
        color: #333 !important;
        text-decoration: none !important;
        transition: all 0.2s;
        font-size: 14px;
        text-align: left;
    }
    .custom-toolbar-dropdown .dropdown-list ul li a:hover {
        background: #f8f9fa;
        color: var(--primary-color, #5dc943) !important;
    }
    
    .filters-toolbar-item, .shop-toolbar {
        overflow: visible !important;
    }

    /* Fix Product Card Image Layout */
    .product-box .product-image .product-img {
        display: block;
        width: 100%;
        height: 100%;
        aspect-ratio: 4 / 5; /* standard product ratio */
        overflow: hidden;
        background-color: #f8f8f8; /* placeholder color */
    }

    .product-box .product-image .product-img img {
        width: 100%;
        height: 100%;
        object-fit: cover !important;
    }

    /* Specific height for combo products or specific grid styles if needed */
    .img-box-h300px {
        height: 300px !important;
    }
</style>
<div id="page-content">
    <div class="template-product">
        <div class="page-header text-center">
            <div class="container-fluid">
                <div class="row align-items-center">
                    <div class="col-12 col-sm-12 col-md-12 col-lg-12">
                        <!--Breadcrumbs-->
                        <div class="breadcrumbs"><a wire:navigate href="<?php echo e(customUrl('/')); ?>"
                                title="Back to the home page"><?php echo e(labels('front_messages.home', 'Home')); ?></a>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(isset($bread_crumb['right_breadcrumb']) && !empty($bread_crumb['right_breadcrumb'])): ?>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $bread_crumb['right_breadcrumb']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $right_breadcrumb): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <span class="main-title fw-bold"><ion-icon class="align-text-top icon"
                                            name="chevron-forward-outline"></ion-icon><?php echo $right_breadcrumb; ?></span>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            <span class="main-title fw-bold"><ion-icon class="align-text-top icon"
                                    name="chevron-forward-outline"></ion-icon><?php echo $bread_crumb['page_main_bread_crumb'] ?? 'Products'; ?></span>
                        </div>
                        <!--End Breadcrumbs-->
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="container-fluid">
        
        <div class="row">
            <!--Sidebar-->
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($showFilter == true): ?>
                <div class="col-12 col-sm-12 col-md-12 col-lg-3 sidebar sidebar-bg filterbar">
                    <div class="closeFilter d-block d-lg-none"><ion-icon class="icon" name="close-outline"></ion-icon>
                    </div>
                    <div class="sidebar-tags sidebar-sticky clearfix">
                        <!--Filter By-->
                            <div class="sidebar-widget filterBox filter-widget border-0 p-0">
                                <div class="d-flex justify-content-between align-items-center gap-2">
                                    <h2><?php echo e(labels('front_messages.filter_by', 'Filters')); ?></h2>
                                    <!-- <p class="cursor-pointer toggle-filter-tab show_tabs m-0">
                                        <?php echo e(labels('front_messages.close_all_tabs', 'Close All Tabs')); ?></p>
                                    <p class="cursor-pointer toggle-filter-tab close_tabs d-none m-0">
                                        <?php echo e(labels('front_messages.show_all_tabs', 'Show All Tabs')); ?></p> -->
                                          <a wire:navigate
                                href="<?php echo e(customUrl(url()->current())); ?>"
                                class="btn btn-sm btn-secondary">
                                <?php echo e(labels('front_messages.clear', 'Reset')); ?>

                                </a>

                                </div>
                            </div>
                        <!--End Filter By-->
                        <!--Price Filter-->
                         <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($min_max_price['max_price'] >= 1): ?>
                        <div class="divider filterBox filter-widget">
                            <div class="widget-title">
                                <h2><?php echo e(labels('front_messages.price', 'Price')); ?></h2>
                            </div>

                            <div class="widget-content price-filter filterDD">
                                <ul class="sidebar-categories scrollspy morelist clearfix">
                                    <?php
                                        $currency_symbol = app(\App\Services\CurrencyService::class)->getDefaultCurrency()->symbol;
                                        $max_val = (int)$min_max_price['max_price'];
                                        $ranges = [
                                            [
                                                'min' => 0,
                                                'max' => 50000,
                                                'label' => 'Less than ' . $currency_symbol . '50,000',
                                            ],
                                            [
                                                'min' => 50000,
                                                'max' => 200000,
                                                'label' => $currency_symbol . '50,000 to ' . $currency_symbol . '2 Lakh',
                                            ],
                                            [
                                                'min' => 200000,
                                                'max' => 350000,
                                                'label' => $currency_symbol . '2 Lakh to ' . $currency_symbol . '3.5 Lakh',
                                            ],
                                            [
                                                'min' => 350000,
                                                'max' => 500000,
                                                'label' => $currency_symbol . '3.5 Lakh to ' . $currency_symbol . '5 Lakh',
                                            ],
                                            [
                                                'min' => 500000,
                                                'max' => 700000,
                                                'label' => $currency_symbol . '5 Lakh to ' . $currency_symbol . '7 Lakh',
                                            ],
                                            [
                                            'min' => 700000,
                                            'max' => $max_val,
                                            'label' => $currency_symbol . '7 Lakh & above',
                                        ]

                                        ];

                                    ?>
                                    <?php
                                        $selected_ranges = explode(',', request()->price_ranges ?? '');
                                        if (request()->min_price !== null && request()->max_price !== null) {
                                            $selected_ranges[] = request()->min_price . '-' . request()->max_price;
                                        }
                                        $visibleCount = 0;
                                    ?>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $ranges; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $range): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($range['min'] < $max_val): ?>
                                            <li class="lvl1 <?php echo e($visibleCount >= 3 ? 'more-item' : ''); ?>"
                                                style="<?php echo e($visibleCount >= 3 ? 'display: none;' : ''); ?>">
                                                <input type="checkbox"
                                                    class="price-range-filter"
                                                    id="price-<?php echo e($range['min']); ?>-<?php echo e($range['max']); ?>"
                                                    data-min="<?php echo e($range['min']); ?>"
                                                    data-max="<?php echo e($range['max']); ?>"
                                                    <?php echo e(in_array($range['min'] . '-' . $range['max'], $selected_ranges) ? 'checked' : ''); ?>>
                                                <label for="price-<?php echo e($range['min']); ?>-<?php echo e($range['max']); ?>">
                                                    <span></span><?php echo e($range['label']); ?>

                                                </label>
                                            </li>
                                            <?php $visibleCount++; ?>
                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </ul>

                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($visibleCount > 3): ?>
                                    <div class="showMore price-show-more">
                                        <a href="javascript:void(0);">
                                            <span class="text"><?php echo e(labels('front_messages.show_more', 'Show More')); ?></span>
                                        </a>
                                    </div>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                                <script>
                                    function initPriceShowMore() {
                                        $('.price-show-more a').off('click').on('click', function() {
                                            let $this = $(this);
                                            let $widget = $this.closest('.widget-content');
                                            let $moreItems = $widget.find('.more-item');
                                            let isExpanded = $moreItems.first().is(':visible');

                                            if (isExpanded) {
                                                $moreItems.slideUp();
                                                $this.find('.text').text("<?php echo e(labels('front_messages.show_more', 'Show More')); ?>");
                                            } else {
                                                $moreItems.slideDown();
                                                $this.find('.text').text("<?php echo e(labels('front_messages.show_less', 'Show Less')); ?>");
                                            }
                                        });
                                    }

                                    function applyPriceFilter() {
                                        initPriceShowMore();

                                        $(document).off('change', '.price-range-filter').on('change', '.price-range-filter', function() {
                                            let checkedRanges = [];
                                            $('.price-range-filter:checked').each(function() {
                                                checkedRanges.push($(this).data('min') + '-' + $(this).data('max'));
                                            });

                                            let url = new URL(window.location.href);
                                            if (checkedRanges.length > 0) {
                                                url.searchParams.set('price_ranges', checkedRanges.join(','));
                                                url.searchParams.delete('min_price');
                                                url.searchParams.delete('max_price');
                                            } else {
                                                url.searchParams.delete('price_ranges');
                                                url.searchParams.delete('min_price');
                                                url.searchParams.delete('max_price');
                                            }

                                            // Reset pagination
                                            url.searchParams.delete('page');

                                            if (typeof Livewire !== 'undefined') {
                                                Livewire.navigate(url.toString());
                                            } else {
                                                window.location.href = url.toString();
                                            }
                                        });
                                    }

                                    document.addEventListener('DOMContentLoaded', applyPriceFilter);
                                    document.addEventListener("livewire:navigated", applyPriceFilter);
                                </script>
                            </div>
                        </div>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>


                        <div class="divider filterBox filter-widget">
                            <div class="widget-title">
                                <h2><?php echo e(labels('front_messages.stock', 'In Stock')); ?></h2>
                            </div>

                            <div class="widget-content filterDD">
                                <ul class="sidebar-categories scrollspy clearfix">
                                    <li class="lvl1">
                                        <input
                                            type="checkbox"
                                            id="in_stock"
                                            <?php echo e(request()->in_stock == 1 ? 'checked' : ''); ?>

                                        />
                                        <label for="in_stock">
                                            <span></span><?php echo e(labels('front_messages.in_stock', 'Show only In-Stock products')); ?>

                                        </label>
                                    </li>
                                </ul>
                            </div>
                        </div>

                        <script>
                            function applyStockFilter() {
                                document.getElementById("in_stock").addEventListener("change", function () {
                                    let url = new URL(window.location.href);

                                    if (this.checked) {
                                        url.searchParams.set("in_stock", 1);
                                    } else {
                                        url.searchParams.delete("in_stock");
                                    }

                                    // Reset pagination
                                    url.searchParams.delete('page');

                                    if (typeof Livewire !== 'undefined') {
                                        Livewire.navigate(url.toString());
                                    } else {
                                        window.location.href = url.toString();
                                    }
                                });
                            }
                            document.addEventListener('DOMContentLoaded', applyStockFilter);
                            document.addEventListener("livewire:navigated", applyStockFilter);
                        </script>



                        
                        <!--End Price Filter-->
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(count($filter_categories ?? []) >= 1): ?>
                            <style>
                                .category-filter-list {
                                    list-style: none;
                                    padding: 0;
                                    margin: 0;
                                }
                                .category-filter-list .cat-item {
                                    display: flex;
                                    align-items: center;
                                    width: 100%;
                                    padding: 4px 0;
                                }
                                .category-filter-list .form-check-input {
                                    width: 18px !important;
                                    height: 18px !important;
                                    margin-top: 0 !important;
                                    cursor: pointer !important;
                                    border: 1px solid #ced4da !important;
                                    display: inline-block !important;
                                    -webkit-appearance: checkbox !important;
                                    appearance: checkbox !important;
                                    opacity: 1 !important;
                                    visibility: visible !important;
                                    position: relative !important;
                                    z-index: 10 !important;
                                    flex-shrink: 0 !important;
                                }
                                .category-filter-list .cat-label {
                                    margin-left: 12px;
                                    cursor: pointer;
                                    flex-grow: 1;
                                    font-size: 15px;
                                    font-weight: 400;
                                    color: #333;
                                    margin-bottom: 0;
                                }
                                .category-filter-list li.lvl1 > .cat-item > .cat-label {
                                    font-weight: 600;
                                    font-size: 16px;
                                }
                                .category-filter-list .sub-menu {
                                    list-style: none;
                                    padding-left: 20px;
                                    margin-bottom: 5px;
                                }
                            </style>
                            <div class="divider filterBox filter-widget category-filter">
                                <div class="widget-title">
                                    <h2><?php echo e(labels('front_messages.categories', 'Categories')); ?></h2>
                                </div>
                                <div class="widget-content filterDD">
                                    <ul class="category-filter-list scrollspy clearfix">
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $filter_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $categoryFilter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li class="lvl1 <?php echo e($loop->index >= 3 ? 'more-item' : ''); ?>"
                                                style="<?php echo e($loop->index >= 3 ? 'display: none;' : ''); ?>">
                                                <input type="checkbox"
                                                       class="category-range-filter"
                                                       id="cat-<?php echo e($categoryFilter->slug); ?>"
                                                       value="<?php echo e($categoryFilter->slug); ?>"
                                                       <?php echo e($categoryFilter->is_checked ? 'checked' : ''); ?>>
                                                <label for="cat-<?php echo e($categoryFilter->slug); ?>" style="font-weight: bold;">
                                                    <span></span><?php echo e($categoryFilter->name); ?>

                                                </label>

                                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(count($categoryFilter->children) > 0): ?>
                                                    <ul class="sub-menu">
                                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $categoryFilter->children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subCat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <li class="lvl2">
                                                                <input type="checkbox"
                                                                       class="category-range-filter"
                                                                       id="cat-<?php echo e($subCat->slug); ?>"
                                                                       value="<?php echo e($subCat->slug); ?>"
                                                                       <?php echo e($subCat->is_checked ? 'checked' : ''); ?>>
                                                                <label for="cat-<?php echo e($subCat->slug); ?>"  >
                                                                    <span></span><?php echo e($subCat->name); ?>

                                                                </label>

                                                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(count($subCat->children) > 0): ?>
                                                                    <ul class="sub-menu">
                                                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $subCat->children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subSubCat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                            <li class="lvl3">
                                                                                <input type="checkbox"
                                                                                       class="category-range-filter"
                                                                                       id="cat-<?php echo e($subSubCat->slug); ?>"
                                                                                       value="<?php echo e($subSubCat->slug); ?>"
                                                                                       <?php echo e($subSubCat->is_checked ? 'checked' : ''); ?>>
                                                                                <label for="cat-<?php echo e($subSubCat->slug); ?>">
                                                                                    <span></span><?php echo e($subSubCat->name); ?>

                                                                                </label>
                                                                            </li>
                                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                                    </ul>
                                                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                            </li>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                    </ul>
                                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                            </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </ul>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(count($filter_categories) > 3): ?>
                                        <div class="showMore category-show-more">
                                            <a href="javascript:void(0);">
                                                <span class="text"><?php echo e(labels('front_messages.show_more', 'Show More')); ?></span>
                                            </a>
                                        </div>
                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </div>
                            </div>

                            <script>
                                function initCategoryShowMore() {
                                    $('.category-show-more a').off('click').on('click', function() {
                                        let $this = $(this);
                                        let $widget = $this.closest('.widget-content');
                                        let $moreItems = $widget.find('.more-item');
                                        let isExpanded = $moreItems.first().is(':visible');

                                        if (isExpanded) {
                                            $moreItems.slideUp();
                                            $this.find('.text').text("<?php echo e(labels('front_messages.show_more', 'Show More')); ?>");
                                            $this.find('i').removeClass('anm-minus-r').addClass('anm-plus-r');
                                        } else {
                                            $moreItems.slideDown();
                                            $this.find('.text').text("<?php echo e(labels('front_messages.show_less', 'Show Less')); ?>");
                                            $this.find('i').removeClass('anm-plus-r').addClass('anm-minus-r');
                                        }
                                    });
                                }

                                function applyCategoryFilter() {
                                    console.log('Attaching category filter listeners');
                                    initCategoryShowMore();

                                    $(document).off('change', '.category-range-filter').on('change', '.category-range-filter', function() {
                                        let selectedSlugs = [];
                                        $('.category-range-filter:checked').each(function() {
                                            selectedSlugs.push($(this).val());
                                        });

                                        let url = new URL(window.location.href);
                                        if (selectedSlugs.length > 0) {
                                            url.searchParams.set('category', selectedSlugs.join(','));
                                        } else {
                                            url.searchParams.delete('category');
                                        }

                                        // Reset pagination
                                        url.searchParams.delete('page');

                                        if (typeof Livewire !== 'undefined') {
                                            Livewire.navigate(url.toString());
                                        } else {
                                            window.location.href = url.toString();
                                        }
                                    });
                                }

                                document.addEventListener('DOMContentLoaded', applyCategoryFilter);
                                document.addEventListener("livewire:navigated", applyCategoryFilter);
                            </script>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(count($Attributes) >= 1): ?>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $Attributes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $Attribute): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="divider filterBox filter-widget brand-filter">
                                        <div class="widget-title">
                                            <h2><?php echo e($Attribute['attribute_name']); ?></h2>
                                        </div>
                                        <div class="widget-content filterDD">
                                            <ul class="sidebar-categories scrollspy clearfix">
                                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $Attribute['attribute_values']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li class="lvl1 <?php echo e($key >= 3 ? 'more-item' : ''); ?>"
                                                        style="<?php echo e($key >= 3 ? 'display: none;' : ''); ?>">
                                                        <input type="checkbox"
                                                                value="<?php echo e($Attribute['attribute_values'][$key]); ?>"
                                                                id="attr-<?php echo e($Attribute['attribute_values'][$key]); ?>-<?php echo e($key); ?>"
                                                                class="product-filter"
                                                                data-attribute="<?php echo e($Attribute['attribute_name']); ?>"
                                                                <?php echo e($Attribute['is_checked'][$key] == true ? 'checked' : ''); ?>>
                                                        <label for="attr-<?php echo e($Attribute['attribute_values'][$key]); ?>-<?php echo e($key); ?>">
                                                            <span></span><?php echo e($Attribute['attribute_values'][$key]); ?>

                                                        </label>
                                                    </li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                            </ul>
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(count($Attribute['attribute_values']) > 3): ?>
                                                <div class="showMore attribute-show-more">
                                                    <a href="javascript:void(0);">
                                                        <span class="text"><?php echo e(labels('front_messages.show_more', 'Show More')); ?></span>
                                                    </a>
                                                </div>
                                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($products_type == 'regular'): ?>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(count($brands) >= 1): ?>
                                    <div class="  filterBox filter-widget brand-filter">
                                        <div class="widget-title">
                                            <h2>Brands</h2>
                                        </div>
                                        <div class="widget-content filterDD">
                                            <ul class="sidebar-categories scrollspy clearfix">
                                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $brands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li class="lvl1 <?php echo e($index >= 3 ? 'more-item' : ''); ?>"
                                                        style="<?php echo e($index >= 3 ? 'display: none;' : ''); ?>">
                                                        <input type="checkbox" value="<?php echo e($brand->slug); ?>"
                                                            id="brand-<?php echo e($brand->slug); ?>" class="brand"
                                                            <?php echo e($brand->is_checked == true ? 'checked' : ''); ?>>
                                                        <label for="brand-<?php echo e($brand->slug); ?>"
                                                            class="d-flex align-items-center"><span></span>
                                                            <div class="filter-brand-img"><img
                                                                    src="<?php echo e(app(MediaService::class)->dynamic_image(app(MediaService::class)->getMediaImageUrl($brand->image), 40)); ?>"
                                                                    alt="<?php echo e(app(TranslationService::class)->getDynamicTranslation(Brand::class, 'name', $brand->id, $language_code)); ?>"
                                                                    srcset=""></div>
                                                            <?php echo e(app(TranslationService::class)->getDynamicTranslation(Brand::class, 'name', $brand->id, $language_code)); ?>

                                                        </label>
                                                    </li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                            </ul>
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(count($brands) > 3): ?>
                                                <div class="showMore brand-show-more">
                                                    <a href="javascript:void(0);">
                                                        <span class="text"><?php echo e(labels('front_messages.show_more', 'Show More')); ?></span>
                                                    </a>
                                                </div>
                                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        </div>
                                    </div>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                            <!-- <div class="text-right">
                                <a wire:navigate
                                href="<?php echo e(customUrl(url()->current())); ?>"
                                class="btn btn-sm btn-secondary">
                                <?php echo e(labels('front_messages.clear', 'Clear')); ?>

                                </a>

                                <button
                                    class="btn btn-sm product-filter-btn"><?php echo e(labels('front_messages.filter', 'filter')); ?></button>
                            </div> -->

                            <script>
                                function initFilterShowMore() {
                                    $('.attribute-show-more a, .brand-show-more a').off('click').on('click', function() {
                                        let $this = $(this);
                                        let $widget = $this.closest('.widget-content');
                                        let $moreItems = $widget.find('.more-item');
                                        let isExpanded = $moreItems.first().is(':visible');

                                        if (isExpanded) {
                                            $moreItems.slideUp();
                                            $this.find('.text').text("<?php echo e(labels('front_messages.show_more', 'Show More')); ?>");
                                        } else {
                                            $moreItems.slideDown();
                                            $this.find('.text').text("<?php echo e(labels('front_messages.show_less', 'Show Less')); ?>");
                                        }
                                    });
                                }

                                function applyBrandAndAttributeFilters() {
                                    initFilterShowMore();

                                    // Brand Filter
                                    $(document).off('change', '.brand').on('change', '.brand', function() {
                                        let url = new URL(window.location.href);
                                        if ($(this).is(':checked')) {
                                            url.searchParams.set('brand', $(this).val());
                                        } else {
                                            url.searchParams.delete('brand');
                                        }

                                        // Reset pagination
                                        url.searchParams.delete('page');

                                        if (typeof Livewire !== 'undefined') {
                                            Livewire.navigate(url.toString());
                                        } else {
                                            window.location.href = url.toString();
                                        }
                                    });

                                    // Attribute Filter
                                    $(document).off('change', '.product-filter').on('change', '.product-filter', function() {
                                        let url = new URL(window.location.href);
                                        let attrName = $(this).data('attribute');
                                        let attrValue = $(this).val();

                                        if ($(this).is(':checked')) {
                                            url.searchParams.set('filter-' + attrName, attrValue);
                                        } else {
                                            url.searchParams.delete('filter-' + attrName);
                                        }

                                        // Reset pagination
                                        url.searchParams.delete('page');

                                        if (typeof Livewire !== 'undefined') {
                                            Livewire.navigate(url.toString());
                                        } else {
                                            window.location.href = url.toString();
                                        }
                                    });
                                }

                                document.addEventListener('DOMContentLoaded', applyBrandAndAttributeFilters);
                                document.addEventListener("livewire:navigated", applyBrandAndAttributeFilters);
                            </script>
                       
                        <div class="sidebar-offers mt-4">
                            <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('offers.offers-section', ['is_sidebar' => true]);

$key = null;

$key ??= \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::generateKey('lw-70790341-0', null);

$__html = app('livewire')->mount($__name, $__params, $key);

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                        </div>
                    </div>

                </div>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

            <!--End Sidebar-->

            <!--Products-->
            <div class="col-12 col-sm-12 col-md-12 <?php echo e($showFilter == true ? 'col-lg-9' : ''); ?>  main-col">

                <?php
                    $activeFilters = [];
                    // Collect attribute filters from query params starting with filter-
                    foreach (request()->query() as $key => $value) {
                        if (strpos($key, 'filter-') === 0 && !empty($value)) {
                            $attrName = str_replace('filter-', '', $key);
                            $activeFilters[] = [
                                'label' => ucfirst($attrName) . ': ' . $value,
                                'remove_keys' => [$key],
                            ];
                        }
                    }
                    // Brand filter chip (brand slug exists in query, name already checked above)
                    if (!empty(request()->query('brand'))) {
                        $brandSlug = request()->query('brand');
                        // Try to find readable name from provided $brands (they have is_checked state)
                        $brandName = null;
                        if (isset($brands)) {
                            foreach ($brands as $b) {
                                if ($b->slug === $brandSlug) {
                                    $brandName = app(\App\Services\TranslationService::class)->getDynamicTranslation(\App\Models\Brand::class, 'name', $b->id, $language_code);
                                    break;
                                }
                            }
                        }
                        $activeFilters[] = [
                            'label' => 'Brand: ' . ($brandName ?? $brandSlug),
                            'remove_keys' => ['brand'],
                        ];
                    }
                    // Price filter chip (only if selected differs from overall min/max)
                    if (isset($min_max_price) && ($min_max_price['selected_min_price'] != $min_max_price['min_price'] || $min_max_price['selected_max_price'] != $min_max_price['max_price'])) {
                        $activeFilters[] = [
                            'label' => 'Price: ' . $min_max_price['selected_min_price'] . ' - ' . $min_max_price['selected_max_price'],
                            'remove_keys' => ['min_price', 'max_price'],
                        ];
                    }
                    // Multiple Price ranges chips
                    if (!empty(request()->query('price_ranges'))) {
                        $p_ranges = explode(',', request()->query('price_ranges'));
                        foreach ($p_ranges as $p_range) {
                            $activeFilters[] = [
                                'label' => 'Price: ' . $p_range,
                                'remove_keys' => ['price_ranges'], // This is tricky, removing one range from a list
                                'range_to_remove' => $p_range,
                            ];
                        }
                    }
                    // Search chip
                    if (!empty($bySearch)) {
                        $activeFilters[] = [
                            'label' => 'Search: ' . $bySearch,
                            'remove_keys' => ['search'],
                        ];
                    }
                ?>


                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(count($sub_categories) >= 1): ?>
                    <?php if (isset($component)) { $__componentOriginal8ee568cd0f20bbfa62a898aab5b649e0 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal8ee568cd0f20bbfa62a898aab5b649e0 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.utility.categories.subCategories.subCategoriesSection','data' => ['subCategories' => $sub_categories,'languageCode' => $language_code]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('utility.categories.subCategories.subCategoriesSection'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['sub_categories' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($sub_categories),'language_code' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($language_code)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal8ee568cd0f20bbfa62a898aab5b649e0)): ?>
<?php $attributes = $__attributesOriginal8ee568cd0f20bbfa62a898aab5b649e0; ?>
<?php unset($__attributesOriginal8ee568cd0f20bbfa62a898aab5b649e0); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal8ee568cd0f20bbfa62a898aab5b649e0)): ?>
<?php $component = $__componentOriginal8ee568cd0f20bbfa62a898aab5b649e0; ?>
<?php unset($__componentOriginal8ee568cd0f20bbfa62a898aab5b649e0); ?>
<?php endif; ?>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                <!--Toolbar-->
                    <div class="toolbar toolbar-wrapper shop-toolbar">
                        <div class="row align-items-center">
                            <div
                                class="col-4 col-sm-2 col-md-4 col-lg-4 text-left filters-toolbar-item d-flex order-1 order-sm-0">
                                <button type="button"
                                    class="p-0 px-2 btn icon anm anm-sliders-hr d-inline-flex d-lg-none me-2"><ion-icon
                                        class="btn-filter icon fs-5" name="options-outline"></ion-icon><span
                                        class="d-none"><?php echo e(labels('front_messages.filter', 'filter')); ?></span></button>
                                <div class="filters-item d-flex align-items-center">
                                    <label
                                        class="mb-0 me-2 d-none d-lg-inline-block"><?php echo e(labels('front_messages.view_as', 'View as')); ?>:</label>
                                    <div class="grid-options view-mode d-flex">
                                        <a class="icon-mode mode-list d-none  d-md-block <?php echo e($view_mode == 'list' ? 'active' : ''); ?>"
                                            data-col="1" data-value="list"></a>
                                        <a class="icon-mode mode-grid grid-2 d-none  d-md-block" data-col="2"></a>
                                        <a class="icon-mode mode-grid grid-3 d-md-block" data-col="3"></a>
                                        <a class="icon-mode mode-grid grid-4 d-lg-block <?php echo e($view_mode == 'list' ? '' : 'active'); ?>"
                                            data-col="4"></a>

                                    </div>
                                </div>
                            </div>
                            <div
                                class="col-12 col-sm-4 col-md-4 col-lg-4 text-center product-count order-0 order-md-1 mb-3 mb-sm-0">
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(count($products_listing) >= 1): ?>
                                    <?php
                                        $currentPage = request()->input('page', 1);
                                        $from = ($currentPage - 1) * $perPage + 1;
                                        $to = min($from + count($products_listing) - 1, $total_products);
                                    ?>
                                    <span class="toolbar-product-count">
                                        <?php echo e(labels('front_messages.showing', 'Showing')); ?>

                                        <?php echo e($from); ?>

                                        <?php echo e(labels('front_messages.to', 'to')); ?>

                                        <?php echo e($to); ?>

                                        <?php echo e(labels('front_messages.of', 'of')); ?>

                                        <?php echo e($total_products); ?>

                                        <?php echo e(labels('front_messages.results', 'results')); ?>

                                    </span>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>
                            <div
                                class="col-8 col-sm-6 col-md-4 col-lg-4 text-right filters-toolbar-item d-flex justify-content-end order-2 order-sm-2">
                                <div class="filters-item d-flex align-items-center ms-2 ms-lg-3">
                                    <label for="perPage"
                                        class="mb-0 me-2 text-nowrap d-none"><?php echo e(labels('front_messages.per_page', 'Per Page')); ?>:</label>
                                    <select name="perPage" id="perPage" class="filters-toolbar-perPage me-2">
                                        <option value="12" <?php echo e($perPage == '12' ? 'selected' : ''); ?>>12
                                        </option>
                                        <option value="16" <?php echo e($perPage == '16' ? 'selected' : ''); ?>>16
                                        </option>
                                        <option value="20" <?php echo e($perPage == '20' ? 'selected' : ''); ?>>20
                                        </option>
                                        <option value="24" <?php echo e($perPage == '24' ? 'selected' : ''); ?>>24
                                        </option>
                                    </select>
                                    
                                    <!-- Custom Sort By Dropdown -->
                                    <div class="custom-toolbar-dropdown sort-by-dropdown">
                                        <div class="dropdown-toggle">
                                            <span><?php echo e($currentSortLabel); ?></span>
                                        </div>
                                        <div class="dropdown-list">
                                            <ul class="m-0 p-0">
                                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $sortByOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li>
                                                        <a wire:navigate href="<?php echo e(request()->fullUrlWithQuery(['sort' => $val, 'page' => 1])); ?>">
                                                            <?php echo e($label); ?>

                                                        </a>
                                                    </li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--End Toolbar-->
                <?php if(count($products_listing) < 1): ?>
                    <?php
                        if (!empty($bySearch)) {
                            $title = labels('front_messages.no_results_for', 'No products found for') . ' "' . $bySearch . '"';
                        } else {
                            $title = labels('front_messages.no_product_found', 'No Product Found!');
                        }
                    ?>
                    <?php if (isset($component)) { $__componentOriginale4b702e8c3649ba189898f4f0dae738c = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginale4b702e8c3649ba189898f4f0dae738c = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.utility.others.not-found','data' => ['title' => $title]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('utility.others.not-found'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($title)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginale4b702e8c3649ba189898f4f0dae738c)): ?>
<?php $attributes = $__attributesOriginale4b702e8c3649ba189898f4f0dae738c; ?>
<?php unset($__attributesOriginale4b702e8c3649ba189898f4f0dae738c); ?>
<?php endif; ?>
<?php if (isset($__componentOriginale4b702e8c3649ba189898f4f0dae738c)): ?>
<?php $component = $__componentOriginale4b702e8c3649ba189898f4f0dae738c; ?>
<?php unset($__componentOriginale4b702e8c3649ba189898f4f0dae738c); ?>
<?php endif; ?>

                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(count($relative_products ?? []) >= 1): ?>
                        <section class="section product-slider pb-0 mt-5">
                            
                            <div class="container-fluid">
                                <?php
                                    $heading['title'] = labels('front_messages.related_products', 'Related Products');
                                    $heading['short_description'] = labels('front_messages.discover_more', 'Discover more amazing products');
                                ?>
                                <?php if (isset($component)) { $__componentOriginal4c70107eded5000fb2dc7412a49867ad = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal4c70107eded5000fb2dc7412a49867ad = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.utility.section_header.sectionHeaderTwo','data' => ['heading' => $heading]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('utility.section_header.sectionHeaderTwo'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['heading' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($heading)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal4c70107eded5000fb2dc7412a49867ad)): ?>
<?php $attributes = $__attributesOriginal4c70107eded5000fb2dc7412a49867ad; ?>
<?php unset($__attributesOriginal4c70107eded5000fb2dc7412a49867ad); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal4c70107eded5000fb2dc7412a49867ad)): ?>
<?php $component = $__componentOriginal4c70107eded5000fb2dc7412a49867ad; ?>
<?php unset($__componentOriginal4c70107eded5000fb2dc7412a49867ad); ?>
<?php endif; ?>
                                
                                <div class="relative-products-wrapper position-relative">
                                    <div class="swiper style1-mySwiper gp15 arwOut5 hov-arrow grid-products
                                        <?php echo e(($store_settings['products_display_style_for_web'] ?? '') == 'products_display_style_for_web_3' ? 'pro-hover3' : ''); ?>"
                                        data-mobile-slides="1">
                                        <div class="swiper-wrapper">
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $relative_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $details): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="swiper-slide">
                                                    <?php
                                                        $component = getProductDisplayComponent($store_settings);
                                                        $details = (object) $details;
                                                    ?>
                                                    <?php if (isset($component)) { $__componentOriginal511d4862ff04963c3c16115c05a86a9d = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal511d4862ff04963c3c16115c05a86a9d = $attributes; } ?>
<?php $component = Illuminate\View\DynamicComponent::resolve(['component' => $component] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('dynamic-component'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\DynamicComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['details' => $details]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal511d4862ff04963c3c16115c05a86a9d)): ?>
<?php $attributes = $__attributesOriginal511d4862ff04963c3c16115c05a86a9d; ?>
<?php unset($__attributesOriginal511d4862ff04963c3c16115c05a86a9d); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal511d4862ff04963c3c16115c05a86a9d)): ?>
<?php $component = $__componentOriginal511d4862ff04963c3c16115c05a86a9d; ?>
<?php unset($__componentOriginal511d4862ff04963c3c16115c05a86a9d); ?>
<?php endif; ?>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        </div>
                                    </div>
                                    <div class="swiper-button-prev related-prev"></div>
                                    <div class="swiper-button-next related-next"></div>
                                </div>
                            </div>
                        </section>

                        <script>
                            document.addEventListener("DOMContentLoaded", function () {
                                initRelatedSwiper();
                            });
                            document.addEventListener("livewire:navigated", function () {
                                initRelatedSwiper();
                            });

                            function initRelatedSwiper() {
                                if (typeof Swiper !== 'undefined') {
                                    new Swiper(".style1-mySwiper", {
                                        slidesPerView: 4,
                                        spaceBetween: 15,
                                        navigation: {
                                            nextEl: ".related-next",
                                            prevEl: ".related-prev",
                                        },
                                        breakpoints: {
                                            320: { slidesPerView: 1, spaceBetween: 10 },
                                            640: { slidesPerView: 2, spaceBetween: 15 },
                                            768: { slidesPerView: 3, spaceBetween: 15 },
                                            1024: { slidesPerView: 4, spaceBetween: 15 },
                                        },
                                    });
                                }
                            }
                        </script>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                <?php else: ?>

                    <!--Product Grid-->
                     <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!empty($activeFilters)): ?>
                     <div class="mb-3 d-flex flex-wrap gap-2 align-items-center">
                         
                         <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $activeFilters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chip): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                             <?php
                                 $params = request()->query();
                                 foreach ($chip['remove_keys'] as $rk) {
                                     if ($rk === 'price_ranges' && isset($chip['range_to_remove'])) {
                                         $ranges = explode(',', $params[$rk] ?? '');
                                         $ranges = array_filter($ranges, fn($r) => $r !== $chip['range_to_remove']);
                                         if (empty($ranges)) {
                                             unset($params[$rk]);
                                         } else {
                                             $params[$rk] = implode(',', $ranges);
                                         }
                                     } else {
                                         unset($params[$rk]);
                                     }
                                 }
                                 $paramsString = count($params) ? ('?' . http_build_query($params)) : '';
                                 $removeUrl = customUrl(url()->current() . $paramsString);
                             ?>
                             <a wire:navigate href="<?php echo e($removeUrl); ?>" class="btn btn-sm btn-outline-secondary ">
                                 <span class="me-1"><?php echo e($chip['label']); ?></span>
                                 <ion-icon name="close-circle-outline"></ion-icon>
                             </a>
                         <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                         <?php
                             $clearUrl = customUrl(url()->current());
                         ?>
                         
                     </div>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    <?php
                        $store_settings = app(StoreService::class)->getStoreSettings();
                    ?>
                    <div class="grid-products grid-view-items mb-4">

                        <div
                            class="row col-row product-options <?php echo e(($store_settings['products_display_style_for_web'] ?? '') == 'products_display_style_for_web_3' ? 'pro-hover3' : ''); ?> <?php echo e($view_mode == 'list' ? 'list-style' : 'row-cols-lg-4 row-cols-md-3 row-cols-sm-3 row-cols-1'); ?> ">
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $products_listing; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $details): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $store_settings = app(StoreService::class)->getStoreSettings();
                                    $component = getProductDisplayComponent($store_settings);
                                    $details = (object) $details;
                                ?>

                                <?php if (isset($component)) { $__componentOriginal511d4862ff04963c3c16115c05a86a9d = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal511d4862ff04963c3c16115c05a86a9d = $attributes; } ?>
<?php $component = Illuminate\View\DynamicComponent::resolve(['component' => $component] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('dynamic-component'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\DynamicComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['details' => $details]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal511d4862ff04963c3c16115c05a86a9d)): ?>
<?php $attributes = $__attributesOriginal511d4862ff04963c3c16115c05a86a9d; ?>
<?php unset($__attributesOriginal511d4862ff04963c3c16115c05a86a9d); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal511d4862ff04963c3c16115c05a86a9d)): ?>
<?php $component = $__componentOriginal511d4862ff04963c3c16115c05a86a9d; ?>
<?php unset($__componentOriginal511d4862ff04963c3c16115c05a86a9d); ?>
<?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </div>
                    </div>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                <!--End Product Grid-->
                <div class="d-flex justify-content-between align-content-center">
                    
                    <?php echo $links; ?>

                </div>
            </div>
            <!--End Products-->
          
        </div>
        
    </div>
    

<input type="hidden" id="min-price" value="<?php echo e($min_max_price['selected_min_price']); ?>">
<input type="hidden" id="max-price" value="<?php echo e($min_max_price['selected_max_price']); ?>">

<input type="hidden" id="selected_min_price" value="<?php echo e($min_max_price['selected_min_price']); ?>">
<input type="hidden" id="selected_max_price" value="<?php echo e($min_max_price['selected_max_price']); ?>">

</div>

<?php /**PATH /home/solarmar/solarmart-web.neuromonk.co.in/resources/views/livewire/elegant/products/listing.blade.php ENDPATH**/ ?>