<?php
    $title = 'Calculator';
?>
<style>
    /* your other CSS */

    .btn-primary {
        background: #2e7d32;
        color: white;
    }

    .btn-primary:hover {
        background: #256628 !important;
    }
</style>

<?php if (isset($component)) { $__componentOriginal5863877a5171c196453bfa0bd807e410 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal5863877a5171c196453bfa0bd807e410 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.layouts.app','data' => ['title' => $title . ' |']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('layouts.app'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($title . ' |')]); ?>
    <div wire:ignore >
        <div id="page-content" >
        <div class="py-4 container-fluid ">
            <div class="row justify-content-center mt-4">
                <div class="col-12">
                    <div class="solar-app">
                        <div class="solar-app-bar">
                            <h1 style="color: #fff;">Solar Calculator</h1>
                            <button class="refresh-btn" onclick="resetCalculator()">
                                <ion-icon name="refresh"></ion-icon>
                            </button>
                        </div>

                        <div class="solar-app-body">
                            <div class="input-group">
                                <select class="dropdown1" id="usageType" onchange="handleUsageTypeChange()">
                                    <option value="">Select Usage Type *</option>
                                    <option value="Residential">Residential</option>
                                    <option value="Commercial">Commercial</option>
                                    <option value="Industrial">Industrial</option>
                                </select>
                            </div>

                            <div class="input-group" id="monthlyBillGroup" style="display: none;">
                                <div class="input-wrapper">
                                    <span class="input-icon">₹</span>
                                    <input type="number" class="input-field" id="monthlyBill"
                                        placeholder="Monthly Electricity Bill (₹)" oninput="handleBillChange()">
                                </div>
                            </div>

                            <div class="results-grid">
                                <div class="result-card" onclick="showSystemSizeDetails()">
                                    <div class="result-card-header">
                                        <span>System Size</span>
                                    </div>
                                    <div class="result-card-value" id="systemSize">0.00 kW</div>
                                </div>
                                <div class="result-card" onclick="showAreaDetails()">
                                    <div class="result-card-header">
                                        <span>Space Req.</span>
                                    </div>
                                    <div class="result-card-value" id="spaceReq">0 sq.ft<br>(0.0 m²)</div>
                                </div>
                                <div class="result-card" onclick="showAnnualEnergyDetails()">
                                    <div class="result-card-header">
                                        <span>Annual Energy</span>
                                    </div>
                                    <div class="result-card-value" id="annualEnergy">0 Units/yr</div>
                                </div>
                                <div class="result-card" onclick="showAnnualSavingDetails()">
                                    <div class="result-card-header">
                                        <span>Annual Saving</span>
                                    </div>
                                    <div class="result-card-value" id="annualSaving">₹ 0</div>
                                </div>
                                <div class="result-card" onclick="showPriceDetails()">
                                    <div class="result-card-header">
                                        <span>System Price</span>
                                    </div>
                                    <div class="result-card-value" id="systemPrice">₹ 0</div>
                                </div>
                                <div class="result-card" onclick="showPaybackDetails()">
                                    <div class="result-card-header">
                                        <span>Payback (yrs)</span>
                                    </div>
                                    <div class="result-card-value" id="payback">-</div>
                                </div>
                            </div>

                            <div class="info-box" id="savingsInfo" style="display: none;">
                                <div class="info-box-title" id="totalSavings">25-year total savings: ₹ 0</div>
                                <p>Yearly degradation assumed: 0.5% (annual generation reduces each year).</p>
                                <button class="btn-primary" onclick="show25YearTable()">View 25-year breakdown</button>
                            </div>

                            <button class="btn-primary" onclick="showContactForm()">Start Your Solar Journey</button>

                            <button class="btn-primary" id="financeBtn" style="display: none;" onclick="toggleFinance()">
                                Interested in Finance?
                            </button>

                            <div class="finance-section" id="financeSection" style="display: none;">
                                <div class="finance-line" id="projectCost">Project Cost: ₹ 0</div>
                                <div class="finance-line" id="downPayment">Down Payment (20%): ₹ 0</div>
                                <div class="finance-line" id="loanAmount">Loan Amount: ₹ 0</div>
                                <div class="finance-subtitle">Approx monthly EMI (simple divide)</div>
                                <div id="emiList"></div>
                            </div>
                        </div>
                    </div>

                    <div class="calc-modal" id="calcCustomModal">
                        <div class="calc-modal-content" id="calcCustomModalContent"></div>
                    </div>

                    <div class="loader" id="loader">
                        <div class="spinner"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <style>
        .solar-app {
           
            overflow: hidden;
           
        }

        .solar-app-bar {
            background: #2e7d32;
            color: #fff;
            padding: 16px 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            max-width: 800px;
            margin: 0 auto;
        }

        .solar-app-body {
            max-width: 800px;
            margin: 0 auto;
            padding: 24px 16px 40px;
            background: #fff;
        }

        .refresh-btn {
            background: none;
            border: none;
            color: inherit;
            cursor: pointer;
            padding: 12px;
            border-radius: 50%;
            transition: background 0.3s;
        }

        .refresh-btn:hover {
            background: rgba(255, 255, 255, 0.15);
        }

        .input-group {
            margin-bottom: 12px;
        }

        .dropdown1,
        .input-field {
            width: 100%;
            padding: 12px 16px;
            border: 1px solid #ddd;
            border-radius: 6px;
            font-size: 14px;
            background: white;
        }

        .input-wrapper {
            position: relative;
        }

        .input-icon {
            position: absolute;
            left: 12px;
            top: 50%;
            transform: translateY(-50%);
            color: #666;
        }

        .input-field {
            padding-left: 40px;
        }

        .dropdown1:focus,
        .input-field:focus {
            outline: none;
            border-color: #2e7d32;
            box-shadow: 0 0 0 2px rgba(33, 150, 243, 0.1);
        }

        .results-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 12px;
            margin: 20px 0;
        }

        .result-card {
            background: white;
            border: 1px solid #e0e0e0;
            border-radius: 10px;
            padding: 12px;
            cursor: pointer;
            transition: all 0.3s;
        }

        .result-card:hover {
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            transform: translateY(-2px);
        }

        .result-card-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 8px;
            font-weight: 600;
            color: #555;
        }

        .result-card-value {
            font-size: 18px;
            font-weight: bold;
            color: #333;
        }

        .info-box {
            background: #e3f2fd;
            padding: 12px;
            border-radius: 8px;
            margin: 18px 0;
        }

        .info-box-title {
            font-weight: bold;
            margin-bottom: 6px;
        }

        .btn-primary {
            width: 100%;
            padding: 14px;
            background: #2e7d32;
            color: white;
            border: none;
            border-radius: 5px;
            font-size: 16px;
            font-weight: 500;
            cursor: pointer;
            transition: background 0.3s;
            margin-top: 10px;
        }

        .btn-primary:hover {
            background: #2e7d32;
        }

        /* Button Loading State */
        .btn-primary.loading {
            position: relative;
            color: transparent !important;
            pointer-events: none;
            opacity: 0.8;
        }

        .btn-spinner {
            display: none;
            position: absolute;
            left: 50%;
            top: 50%;
            transform: translate(-50%, -50%);
            width: 20px;
            height: 20px;
            border: 3px solid rgba(255, 255, 255, 0.3);
            border-top: 3px solid #fff;
            border-radius: 50%;
            animation: spin 0.8s linear infinite;
        }

        .loading .btn-spinner {
            display: block;
        }

        /* Success Screen */
        .success-screen {
            text-align: center;
            padding: 20px 0;
        }

        .success-icon {
            color: #2e7d32;
            font-size: 64px;
            margin-bottom: 20px;
        }

        .success-screen h3 {
            font-size: 24px;
            margin-bottom: 10px;
            color: #333;
        }

        .success-screen p {
            color: #666;
            margin-bottom: 24px;
        }

        .error-text {
            color: #d32f2f;
            font-size: 13px;
            margin-top: 10px;
            text-align: center;
            display: none;
        }

        /* Table Styles for 25-year breakdown */
        .calc-table-header {
            display: grid;
            grid-template-columns: 80px 1fr 1fr;
            padding: 12px;
            background: #f8f9fa;
            border-radius: 8px 8px 0 0;
            font-weight: bold;
            color: #2e7d32;
            border-bottom: 2px solid #e0e0e0;
            margin-top: 10px;
        }

        .calc-table-row {
            display: grid;
            grid-template-columns: 80px 1fr 1fr;
            padding: 12px;
            border-bottom: 1px solid #eee;
            align-items: center;
        }

        .calc-table-row:last-child {
            border-bottom: none;
        }

        .calc-table-row:nth-child(even) {
            background: #fafafa;
        }

        .cell-year { font-weight: 600; }
        .cell-units { color: #666; font-size: 14px; }
        .cell-savings { font-weight: bold; text-align: right; color: #333; }
        .header-savings { text-align: right; }

        .finance-section {
            background: white;
            padding: 16px;
            border-radius: 8px;
            margin-top: 12px;
            border: 1px solid #e0e0e0;
        }

        .finance-line {
            font-weight: 600;
            margin-bottom: 6px;
        }

        .finance-subtitle {
            font-weight: 600;
            margin: 10px 0 4px;
        }

        .finance-row {
            display: flex;
            justify-content: space-between;
            padding: 6px 0;
            border-bottom: 1px dashed #eee;
        }

        .finance-row:last-child {
            border-bottom: none;
        }

        .calc-modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            z-index: 1050;
            animation: fadeIn 0.3s;
        }

        .calc-modal.active {
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .calc-modal-content {
            background: white;
            width: 95%;
            max-width: 600px;
            max-height: 85vh;
            border-radius: 12px;
            padding: 24px;
            overflow-y: auto;
            position: relative;
            animation: modalPop 0.3s ease-out;
        }

        .calc-modal-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 16px;
        }

        .calc-modal-title {
            font-size: 18px;
            font-weight: bold;
        }

        .close-btn {
            background: none;
            border: none;
            font-size: 24px;
            cursor: pointer;
            color: #666;
        }

        .loader {
            display: none;
            position: fixed;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            z-index: 1100;
        }

        .loader.active {
            display: block;
        }

        .spinner {
            width: 50px;
            height: 50px;
            border: 4px solid #f3f3f3;
            border-top: 4px solid #2e7d32;
            border-radius: 50%;
            animation: spin 1s linear infinite;
        }

        @keyframes spin {
            0% {
                transform: rotate(0deg);
            }

            100% {
                transform: rotate(360deg);
            }
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
            }

            to {
                opacity: 1;
            }
        }

        @keyframes modalPop {
            from {
                opacity: 0;
                transform: scale(0.9) translateY(20px);
            }
            to {
                opacity: 1;
                transform: scale(1) translateY(0);
            }
        }
    </style>

    <script>
        const STATES = ['Andhra Pradesh', 'Arunachal Pradesh', 'Assam', 'Bihar', 'Chhattisgarh', 'Goa', 'Gujarat', 'Haryana', 'Himachal Pradesh', 'Jharkhand', 'Karnataka', 'Kerala', 'Madhya Pradesh', 'Maharashtra', 'Manipur', 'Meghalaya', 'Mizoram', 'Nagaland', 'Odisha', 'Punjab', 'Rajasthan', 'Sikkim', 'Tamil Nadu', 'Telangana', 'Tripura', 'Uttar Pradesh', 'Uttarakhand', 'West Bengal', 'Andaman and Nicobar Islands', 'Chandigarh', 'Dadra and Nagar Haveli and Daman and Diu', 'Delhi', 'Jammu and Kashmir', 'Ladakh', 'Lakshadweep', 'Puducherry'];
        const FINANCE_OPTIONS = ['Yes', 'No', 'Maybe'];

        class SolarCalculator {
            constructor(monthlyBill, customerType) {
                this.monthlyBill = monthlyBill;
                this.customerType = customerType;
                this.generationPerKWPerYear = 1350;
                this.costPerKW = 70000;
                this.areaSqFtPerKW = 70;
                this.areaM2PerKW = 8;
                this.degradationRate = 0.005;
            }

            get unitRate() {
                const rates = {
                    Residential: 10,
                    Commercial: 25,
                    Industrial: 12,
                };
                return rates[this.customerType] || 10;
            }

            get annualBill() {
                return this.monthlyBill * 12;
            }

            get annualUnits() {
                return this.annualBill / this.unitRate;
            }

            get requiredSystemKW() {
                return this.annualUnits / this.generationPerKWPerYear;
            }

            get requiredSystemKWRounded() {
                const step = 0.5;
                return Math.ceil(this.requiredSystemKW / step) * step;
            }

            get areaSqFt() {
                return this.requiredSystemKWRounded * this.areaSqFtPerKW;
            }

            get areaM2() {
                return this.requiredSystemKWRounded * this.areaM2PerKW;
            }

            get annualGeneration() {
                return this.requiredSystemKWRounded * this.generationPerKWPerYear;
            }

            get annualSaving() {
                return this.annualGeneration * this.unitRate;
            }

            get systemPrice() {
                return this.requiredSystemKWRounded * this.costPerKW;
            }

            get paybackYears() {
                return this.systemPrice / this.annualSaving;
            }

            generationTable(years = 25) {
                const table = [];
                let gen = this.annualGeneration;
                for (let i = 1; i <= years; i++) {
                    table.push({
                        year: i,
                        generation: gen,
                        saving: gen * this.unitRate,
                    });
                    gen *= 1 - this.degradationRate;
                }
                return table;
            }

            totalSavingForYears(years) {
                return this.generationTable(years).reduce((sum, row) => sum + row.saving, 0);
            }
        }

        function formatIndianCurrency(amount) {
            return new Intl.NumberFormat('en-IN').format(Math.round(amount));
        }

        let calculator = null;

        function handleUsageTypeChange() {
            const usageType = document.getElementById('usageType').value;
            const billInput = document.getElementById('monthlyBill');
            const billGroup = document.getElementById('monthlyBillGroup');
            
            if (usageType) {
                billGroup.style.display = 'block';
                billInput.disabled = false;
            } else {
                billGroup.style.display = 'none';
                billInput.disabled = true;
                billInput.value = '';
            }

            if (usageType) {
                updateCalculations();
            }
        }

        function handleBillChange() {
            const bill = parseFloat(document.getElementById('monthlyBill').value) || 0;
            document.getElementById('financeBtn').style.display = bill > 0 ? 'block' : 'none';
            document.getElementById('savingsInfo').style.display = bill > 0 ? 'block' : 'none';
            updateCalculations();
        }

        function updateCalculations() {
            const monthlyBill = parseFloat(document.getElementById('monthlyBill').value) || 0;
            const usageType = document.getElementById('usageType').value;

            if (!usageType || monthlyBill <= 0) {
                return;
            }

            calculator = new SolarCalculator(monthlyBill, usageType);

            document.getElementById('systemSize').textContent = `${calculator.requiredSystemKWRounded.toFixed(2)} kW`;
            document.getElementById('spaceReq').innerHTML = `${Math.round(calculator.areaSqFt)} sq.ft<br>(${calculator.areaM2.toFixed(1)} m²)`;
            document.getElementById('annualEnergy').textContent = `${Math.round(calculator.annualGeneration)} Units/yr`;
            document.getElementById('annualSaving').textContent = `₹ ${formatIndianCurrency(calculator.annualSaving)}`;
            document.getElementById('systemPrice').textContent = `₹ ${formatIndianCurrency(calculator.systemPrice)}`;
            document.getElementById('payback').textContent = Number.isFinite(calculator.paybackYears) ? calculator.paybackYears.toFixed(2) : '-';

            const total25Year = calculator.totalSavingForYears(25);
            document.getElementById('totalSavings').textContent = `25-year total savings: ₹ ${formatIndianCurrency(total25Year)}`;

            updateFinanceSection();
        }

        function updateFinanceSection() {
            if (!calculator) return;
            const projectCost = Math.round(calculator.systemPrice);
            const downPayment = Math.round(projectCost * 0.2);
            const loanAmount = projectCost - downPayment;

            document.getElementById('projectCost').textContent = `Project Cost: ₹ ${formatIndianCurrency(projectCost)}`;
            document.getElementById('downPayment').textContent = `Down Payment (20%): ₹ ${formatIndianCurrency(downPayment)}`;
            document.getElementById('loanAmount').textContent = `Loan Amount: ₹ ${formatIndianCurrency(loanAmount)}`;

            const tenures = [6, 12, 24, 36, 48, 60];
            const emiList = document.getElementById('emiList');
            emiList.innerHTML = tenures
                .map((t) => {
                    const emi = Math.ceil(loanAmount / t);
                    return `<div class="finance-row"><span>${t} months</span><span>₹ ${formatIndianCurrency(emi)}</span></div>`;
                })
                .join('');
        }

        function toggleFinance() {
            const section = document.getElementById('financeSection');
            section.style.display = section.style.display === 'none' ? 'block' : 'none';
        }

        function showModal(content) {
            document.getElementById('calcCustomModalContent').innerHTML = content;
            document.getElementById('calcCustomModal').classList.add('active');
        }

        function closeModal() {
            document.getElementById('calcCustomModal').classList.remove('active');
        }

        document.getElementById('calcCustomModal').addEventListener('click', function (e) {
            if (e.target === this) closeModal();
        });

        function showSystemSizeDetails() {
            if (!calculator) return;
            const content = `
                <div class="modal-header">
                    <div class="modal-title">How System Size is calculated</div>
                    <button class="close-btn" onclick="closeModal()">×</button>
                </div>
                <p><strong>Formulas:</strong></p>
                <p>Annual Bill = Monthly Bill × 12</p>
                <p>Annual Units = Annual Bill ÷ Unit Rate (₹${calculator.unitRate.toFixed(2)}/unit)</p>
                <p>System Size (kW) = Annual Units ÷ ${calculator.generationPerKWPerYear}</p>
                <p><strong>In your case:</strong></p>
                <p>Monthly bill: ₹${calculator.monthlyBill.toFixed(2)}</p>
                <p>Annual bill: ₹${calculator.annualBill.toFixed(2)}</p>
                <p>Annual units: ${calculator.annualUnits.toFixed(2)} units</p>
                <p>Required system (rounded): ${calculator.requiredSystemKWRounded.toFixed(2)} kW</p>
            `;
            showModal(content);
        }

        function showAreaDetails() {
            if (!calculator) return;
            const content = `
                <div class="modal-header">
                    <div class="modal-title">Space Required</div>
                    <button class="close-btn" onclick="closeModal()">×</button>
                </div>
                <p>Formula: Area = System Size (kW) × 70 sq.ft (≈8 m² per kW)</p>
                <p>Required area: ${Math.round(calculator.areaSqFt)} sq.ft</p>
                <p>Required area: ${calculator.areaM2.toFixed(1)} m²</p>
            `;
            showModal(content);
        }

        function showAnnualEnergyDetails() {
            if (!calculator) return;
            const content = `
                <div class="modal-header">
                    <div class="modal-title">Annual Energy Generation</div>
                    <button class="close-btn" onclick="closeModal()">×</button>
                </div>
                <p>Formula: Annual generation = System Size (kW) × ${calculator.generationPerKWPerYear}</p>
                <p>Your annual generation: ${Math.round(calculator.annualGeneration)} units/year</p>
            `;
            showModal(content);
        }

        function showAnnualSavingDetails() {
            if (!calculator) return;
            const content = `
                <div class="modal-header">
                    <div class="modal-title">Annual Savings</div>
                    <button class="close-btn" onclick="closeModal()">×</button>
                </div>
                <p>Formula: Annual saving = Annual generation × unit rate (₹${calculator.unitRate.toFixed(2)})</p>
                <p>Your annual saving: ₹ ${formatIndianCurrency(calculator.annualSaving)}</p>
            `;
            showModal(content);
        }

        function showPriceDetails() {
            if (!calculator) return;
            const content = `
                <div class="modal-header">
                    <div class="modal-title">System Price (Excl. GST)</div>
                    <button class="close-btn" onclick="closeModal()">×</button>
                </div>
                <p>Formula: Price = System Size (kW) × ₹${calculator.costPerKW.toFixed(0)}</p>
                <p>Estimated system price: ₹ ${formatIndianCurrency(calculator.systemPrice)}</p>
                <p>Subsidy (example): depends on state policies — configure as needed.</p>
            `;
            showModal(content);
        }

        function showPaybackDetails() {
            if (!calculator) return;
            const content = `
                <div class="modal-header">
                    <div class="modal-title">Payback (Years)</div>
                    <button class="close-btn" onclick="closeModal()">×</button>
                </div>
                <p>Formula: Payback = System Price ÷ Annual Saving</p>
                <p>System Price: ₹ ${formatIndianCurrency(calculator.systemPrice)}</p>
                <p>Annual Saving: ₹ ${formatIndianCurrency(calculator.annualSaving)}</p>
                <p>Payback: ${calculator.paybackYears.toFixed(2)} years</p>
            `;
            showModal(content);
        }

        function show25YearTable() {
            if (!calculator) return;
            const rows = calculator
                .generationTable(25)
                .map(
                    (row) => `
                <div class="calc-table-row">
                    <div class="cell-year">Year ${row.year}</div>
                    <div class="cell-units">${Math.round(row.generation)} Units</div>
                    <div class="cell-savings">₹ ${formatIndianCurrency(row.saving)}</div>
                </div>`
                )
                .join('');

            const content = `
                <div class="modal-header">
                    <div class="modal-title">25-year generation & savings</div>
                    <button class="close-btn" onclick="closeModal()">×</button>
                </div>
                <div class="calc-table-header">
                    <div>Year</div>
                    <div>Units</div>
                    <div class="header-savings">Savings</div>
                </div>
                <div style="max-height: 50vh; overflow-y: auto; border: 1px solid #eee; border-top: none; border-radius: 0 0 8px 8px;">
                    ${rows}
                </div>
            `;
            showModal(content);
        }

        function showContactForm() {
            const stateOptions = STATES.map((s) => `<option value="${s}">${s}</option>`).join('');
            const financeOptions = FINANCE_OPTIONS.map((f) => `<option value="${f}">${f}</option>`).join('');

            const content = `
                <div class="modal-header">
                    <div class="modal-title">Start Your Solar Journey</div>
                    <button class="close-btn" onclick="closeModal()">×</button>
                </div>
                <form id="contactForm" onsubmit="submitForm(event)">
                    <div class="form-group">
                        <input type="text" class="input-field" id="fullName" placeholder="Full Name" required>
                    </div>
                    <div class="form-group">
                        <input type="email" class="input-field" id="email" placeholder="Email ID" required>
                    </div>
                    <div class="form-group">
                        <input type="tel" class="input-field" id="mobile" placeholder="Mobile" maxlength="10" pattern="[0-9]{10}" required>
                    </div>
                    <div class="form-group">
                        <select class="dropdown1" id="state" required>
                            <option value="">Select State</option>
                            ${stateOptions}
                        </select>
                    </div>
                    <div class="form-group">
                        <select class="dropdown1" id="finance" required>
                            <option value="">Interested in Finance?</option>
                            ${financeOptions}
                        </select>
                    </div>
                    <button type="submit" class="btn-primary" id="contactSubmitBtn">
                        <span class="btn-text">Submit</span>
                        <div class="btn-spinner"></div>
                    </button>
                    <div id="formError" class="error-text"></div>
                </form>
            `;
            showModal(content);
        }

        async function submitForm(event) {
            event.preventDefault();

            const data = {
                full_name: document.getElementById('fullName').value,
                email: document.getElementById('email').value,
                mobile_number: document.getElementById('mobile').value,
                state: document.getElementById('state').value,
                usage_type: document.getElementById('usageType').value,
                average_monthly_electricity_bill: document.getElementById('monthlyBill').value,
                interested_in_finance: document.getElementById('finance').value,
            };

            const submitBtn = document.getElementById('contactSubmitBtn');
            submitBtn.classList.add('loading');

            try {
                const response = await fetch('https://solarmart.neuromonk.co.in/api/startWithSolar', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                    },
                    body: JSON.stringify(data),
                });

                submitBtn.classList.remove('loading');

                if (response.ok) {
                    const result = await response.json();
                    document.getElementById('calcCustomModalContent').innerHTML = `
                        
                        <div class="success-screen">
                            <div class="success-icon">
                                <ion-icon name="checkmark-circle"></ion-icon>
                            </div>
                            <h3>Thank You!</h3>
                            <p>${result.message || 'Your solar journey has started. Our team will contact you soon.'}</p>
                            <button class="btn-primary" onclick="closeModal()">Close</button>
                        </div>
                    `;
                } else {
                    const errorMsg = document.getElementById('formError');
                    errorMsg.textContent = `Failed: ${response.status}. Please try again.`;
                    errorMsg.style.display = 'block';
                }
            } catch (error) {
                submitBtn.classList.remove('loading');
                const errorMsg = document.getElementById('formError');
                errorMsg.textContent = `Error: ${error.message}. Please check your connection.`;
                errorMsg.style.display = 'block';
            }
        }

        function resetCalculator() {
            document.getElementById('usageType').value = '';
            document.getElementById('monthlyBill').value = '';
            document.getElementById('monthlyBill').disabled = true;
            document.getElementById('monthlyBillGroup').style.display = 'none';
            document.getElementById('financeSection').style.display = 'none';
            document.getElementById('financeBtn').style.display = 'none';
            document.getElementById('savingsInfo').style.display = 'none';
            calculator = null;

            document.getElementById('systemSize').textContent = '0.00 kW';
            document.getElementById('spaceReq').innerHTML = '0 sq.ft<br>(0.0 m²)';
            document.getElementById('annualEnergy').textContent = '0 Units/yr';
            document.getElementById('annualSaving').textContent = '₹ 0';
            document.getElementById('systemPrice').textContent = '₹ 0';
            document.getElementById('payback').textContent = '-';
        }
    </script>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal5863877a5171c196453bfa0bd807e410)): ?>
<?php $attributes = $__attributesOriginal5863877a5171c196453bfa0bd807e410; ?>
<?php unset($__attributesOriginal5863877a5171c196453bfa0bd807e410); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal5863877a5171c196453bfa0bd807e410)): ?>
<?php $component = $__componentOriginal5863877a5171c196453bfa0bd807e410; ?>
<?php unset($__componentOriginal5863877a5171c196453bfa0bd807e410); ?>
<?php endif; ?>
<?php /**PATH /home/solarmar/solarmart-web.neuromonk.co.in/resources/views/livewire/elegant/pages/calculator.blade.php ENDPATH**/ ?>