<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag; ?>
<?php foreach($attributes->onlyProps(['sub_categories','language_code']) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $attributes = $attributes->exceptProps(['sub_categories','language_code']); ?>
<?php foreach (array_filter((['sub_categories','language_code']), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $__defined_vars = get_defined_vars(); ?>
<?php foreach ($attributes as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
} ?>
<?php unset($__defined_vars); ?>
<?php
use App\Models\Category;
use App\Services\TranslationService;
?>


<div class="swiper sub_category-mySwiper mb-2">
    <div class="swiper-wrapper">
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $sub_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sub_category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <a href="<?php echo e(customUrl('categories/' . $sub_category->slug . '/products')); ?>"
            class="swiper-slide category-link clr-none">
            <div class="zoom-scal zoom-scal-nopb rounded-0 sub_categories_image">

                <img
                    class="rounded-0 blur-up lazyload w-full h-full object-cover"
                    src="<?php echo e($sub_category->image_url); ?>"
                    alt="<?php echo e(app(TranslationService::class)->getDynamicTranslation(
                        Category::class,
                        'name',
                        $sub_category->id,
                        $language_code
                    )); ?>"
                                    title="<?php echo e(app(TranslationService::class)->getDynamicTranslation(
                        Category::class,
                        'name',
                        $sub_category->id,
                        $language_code
                    )); ?>" />

            </div>
            <div class="details text-center">
                <h4 class="category-title mb-0">
                    <?php echo e(app(TranslationService::class)->getDynamicTranslation(Category::class, 'name', $sub_category->id, $language_code)); ?>

                </h4>
            </div>
        </a>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    </div>
    <div class="swiper-button-prev"></div>
</div>
<script>
    document.addEventListener("DOMContentLoaded", function () {
        initSubCategorySwiper();
    });

    document.addEventListener("livewire:navigated", function () {
        initSubCategorySwiper();
    });

    function initSubCategorySwiper() {
        if (typeof Swiper !== 'undefined') {
            new Swiper(".sub_category-mySwiper", {
                slidesPerView: 6,
                spaceBetween: 20,
                navigation: {
                    nextEl: ".swiper-button-next",
                    prevEl: ".swiper-button-prev",
                },
                breakpoints: {
                    320: { slidesPerView: 2, spaceBetween: 10 },
                    640: { slidesPerView: 3, spaceBetween: 15 },
                    768: { slidesPerView: 4, spaceBetween: 20 },
                    1024: { slidesPerView: 6, spaceBetween: 20 },
                },
            });
        }
    }
</script>
<?php /**PATH /home/solarmar/solarmart-web.neuromonk.co.in/resources/views/components/utility/categories/subCategories/subCategoriesSection.blade.php ENDPATH**/ ?>