<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag; ?>
<?php foreach($attributes->onlyProps(['cartItem', 'is_save_later_hide', 'is_remove_from_cart', 'product_availability', 'for_checkout']) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $attributes = $attributes->exceptProps(['cartItem', 'is_save_later_hide', 'is_remove_from_cart', 'product_availability', 'for_checkout']); ?>
<?php foreach (array_filter((['cartItem', 'is_save_later_hide', 'is_remove_from_cart', 'product_availability', 'for_checkout']), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $__defined_vars = get_defined_vars(); ?>
<?php foreach ($attributes as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
} ?>
<?php unset($__defined_vars); ?>
<?php
    use App\Models\Product;
    use App\Models\ComboProduct;
    use App\Services\TranslationService;
    use App\Services\CurrencyService;
    use App\Services\MediaService;
    $language_code = app(TranslationService::class)->getLanguageCode();
?>

<?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($cartItem->cart_product_type == 'regular'): ?>
    <tr class="cart-row cart-flex position-relative">
        
        <td class="cart-delete text-center small-hide">
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($is_remove_from_cart == 0): ?>
                <button type="button" class="cart-remove border-0 remove-icon position-static" data-bs-toggle="tooltip"
                    data-bs-placement="top" title="Remove to Cart" wire:click="remove_from_cart(<?php echo e($cartItem->product_variant_id); ?>)">
                    <ion-icon wire:ignore name="close" class="fs-5"></ion-icon>
                </button>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </td>
        <td class="cart-image cart-flex-item">
            <?php
                $cart_image = app(MediaService::class)->dynamic_image($cartItem->product->image, 84);
                $product_name = app(TranslationService::class)->getDynamicTranslation(Product::class, 'name', $cartItem->product->id, $language_code);
            ?>
            <a href="<?php echo e(customUrl('products/' . $cartItem->product->slug)); ?>" wire:navigate><img
                    class="cart-image rounded-0 blur-up lazyload" data-src="<?php echo e($cart_image); ?>"
                    src="<?php echo e($cart_image); ?>" alt="<?php echo e($product_name); ?>" /></a>
        </td>
        <td class="cart-meta small-text-left cart-flex-item">
            <div class="list-view-item-title">
                <a href="<?php echo e(customUrl('products/' . $cartItem->product->slug)); ?>" wire:navigate><?php echo e($product_name); ?></a>
            </div>
            <div class="cart-meta-text">
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(isset($product_availability['is_deliverable']) && $product_availability['is_deliverable'] == false): ?>
                    <p class="m-0 fw-500 text-capitalize text-danger"><?php echo e($product_name); ?> is Not deliverable at
                        Selected Address</p>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                <?php
                    // Safely read variant values – some cart items may not have variants
                    $variant_values = '';
                    if (!empty($cartItem['product_variants']) && isset($cartItem['product_variants'][0]['variant_values'])) {
                        $variant_values = $cartItem['product_variants'][0]['variant_values'];
                        $variant_values = str_replace(',', '/', $variant_values);
                    }
                ?>
                <?php echo $variant_values . ($variant_values != '' ? '<br>' : ''); ?><?php echo e(labels('front_messages.qty', 'Qty')); ?>:
                <?php echo e($cartItem->qty); ?>

            </div>
            <div class="cart-price d-md-none">
                <span class="money fw-500"><?php echo e(app(CurrencyService::class)->currentCurrencyPrice($cartItem->productVariant->special_price, true)); ?></span>
            </div>
        </td>
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($is_save_later_hide == 0): ?>
            <td class="cart-price cart-flex-item text-center small-hide">
                <button type="button" class="btn btn-brd"
                    wire:click="save_for_later(<?php echo e($cartItem->product_variant_id); ?>)"><?php echo e(labels('front_messages.save_for_later', 'Save for Later')); ?></button>
            </td>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        <td class="cart-price cart-flex-item text-center small-hide">
            <span class="money">
                <?php
                    $finalPrice =
                        $cartItem->productVariant->special_price && $cartItem->productVariant->special_price > 0
                            ? app(CurrencyService::class)->currentCurrencyPrice($cartItem->productVariant->special_price, true)
                            : app(CurrencyService::class)->currentCurrencyPrice($cartItem->productVariant->price, true);
                ?>
                <?php echo e($finalPrice); ?>

            </span>
        </td>

        <td class="cart-update-wrapper cart-flex-item text-end text-md-center">
            <div class="cart-qty d-flex justify-content-end justify-content-md-center">
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($for_checkout != 1): ?>
                    <div class="qtyField">
                        <button type="button" wire:ignore class="qtyBtn minus">
                            <ion-icon name="remove-outline"></ion-icon>
                        </button>

                        <input class="cart-qty-input qty" type="text" name="updates[]"
                            value="<?php echo e($cartItem->qty); ?>" pattern="[0-9]*"
                            max="<?php echo e($cartItem->product->total_allowed_quantity == 0 ? 'Infinity' : $cartItem->product->total_allowed_quantity); ?>"
                            min="<?php echo e($cartItem->product->minimum_order_quantity); ?>"
                            step="<?php echo e($cartItem->product->quantity_step_size); ?>" data-variant-id="<?php echo e($cartItem->product_variant_id); ?>"
                            data-product-type="regular" />


                        <button type="button" wire:ignore class="qtyBtn plus">
                            <ion-icon name="add-outline"></ion-icon>
                        </button>
                    </div>
                <?php else: ?>
                    <?php echo e($cartItem->qty); ?>

                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

            </div>
            <button type="button" title="Remove"
                class="removeMb d-md-none d-inline-block text-decoration-underline border-0"
                wire:click="save_for_later(<?php echo e($cartItem->product_variant_id); ?>)"><?php echo e(labels('front_messages.save_for_later', 'Save for Later')); ?></button>
            <button type="button" title="Remove"
                class="removeMb d-md-none d-inline-block text-decoration-underline border-0"
                wire:click="remove_from_cart(<?php echo e($cartItem->product_variant_id); ?>)"><?php echo e(labels('front_messages.remove', 'Remove')); ?></button>
        </td>
        <td class="cart-price cart-flex-item text-center small-hide">
            <?php
                $priceToUse =
                    $cartItem->productVariant->special_price && $cartItem->productVariant->special_price > 0
                        ? $cartItem->productVariant->special_price
                        : $cartItem->productVariant->price;
                $cart_total = $priceToUse * $cartItem->qty;
            ?>
            <span class="money fw-500"><?php echo e(app(CurrencyService::class)->currentCurrencyPrice($cart_total, true)); ?></span>
        </td>

    </tr>
<?php else: ?>
    <tr class="cart-row cart-flex position-relative">

        <td class="cart-delete text-center small-hide">
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($is_remove_from_cart == 0): ?>
                <button type="button" class="cart-remove border-0 remove-icon position-static" data-bs-toggle="tooltip"
                    data-bs-placement="top" title="Remove to Cart"
                    wire:click="remove_from_cart(<?php echo e($cartItem->product_variant_id); ?>)">
                    <ion-icon wire:ignore name="close" class="fs-5"></ion-icon>
                </button>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </td>
        <td class="cart-image cart-flex-item">
            <?php
                $cart_image = app(MediaService::class)->dynamic_image($cartItem->comboProduct->image, 84);
                $combo_product_name = app(TranslationService::class)->getDynamicTranslation(
                    ComboProduct::class,
                    'title',
                    $cartItem->comboProduct->id,
                    $language_code,
                );
            ?>
            <a href="<?php echo e(customUrl('combo-products/' . $cartItem->comboProduct->slug)); ?>" wire:navigate><img
                    class="cart-image rounded-0 blur-up lazyload" data-src="<?php echo e($cart_image); ?>"
                    src="<?php echo e($cart_image); ?>" alt="<?php echo e($combo_product_name); ?>" /></a>
        </td>
        <td class="cart-meta small-text-left cart-flex-item">
            <div class="list-view-item-title">
                <a href="<?php echo e(customUrl('combo-products/' . $cartItem->comboProduct->slug)); ?>"
                    wire:navigate><?php echo e($combo_product_name); ?></a>
            </div>
          
            <div class="cart-meta-text"><?php echo e(labels('front_messages.qty', 'Qty')); ?>: <?php echo e($cartItem->qty); ?>

            </div>
            <div class="cart-price d-md-none">
                <span class="money fw-500"><?php echo e(app(CurrencyService::class)->currentCurrencyPrice($cartItem->comboProduct->special_price, true)); ?></span>
            </div>
        </td>
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($is_save_later_hide == 0): ?>
            <td class="cart-price cart-flex-item text-center small-hide">
                <button type="button" class="btn btn-brd"
                    wire:click="save_for_later(<?php echo e($cartItem->product_variant_id); ?>)"><?php echo e(labels('front_messages.save_for_later', 'Save for Later')); ?></button>
            </td>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        <td class="cart-price cart-flex-item text-center small-hide">
            <span class="money">
                <?php
                    $priceToDisplay =
                        $cartItem->comboProduct->special_price && $cartItem->comboProduct->special_price > 0
                            ? $cartItem->comboProduct->special_price
                            : $cartItem->comboProduct->price;
                ?>
                <?php echo e(app(CurrencyService::class)->currentCurrencyPrice($priceToDisplay, true)); ?>

            </span>
        </td>

        <td class="cart-update-wrapper cart-flex-item text-end text-md-center">
            <div class="cart-qty d-flex justify-content-end justify-content-md-center">
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($for_checkout != 1): ?>
                    <div class="qtyField">
                        <button type="button" wire:ignore class="qtyBtn minus">
                            <ion-icon name="remove-outline"></ion-icon>
                        </button>
                        <input class="cart-qty-input qty" type="text" name="updates[]"
                            value="<?php echo e($cartItem->qty); ?>" pattern="[0-9]*"
                            max="<?php echo e($cartItem->comboProduct->total_allowed_quantity == 0 ? 'Infinity' : $cartItem->comboProduct->total_allowed_quantity); ?>"
                            min="<?php echo e($cartItem->comboProduct->minimum_order_quantity); ?>"
                            step="<?php echo e($cartItem->comboProduct->quantity_step_size); ?>" data-variant-id="<?php echo e($cartItem->product_variant_id); ?>"
                            data-product-type="combo" />
                        <button type="button" wire:ignore class="qtyBtn plus">
                            <ion-icon name="add-outline"></ion-icon>
                        </button>
                    </div>
                <?php else: ?>
                    <?php echo e($cartItem->qty); ?>

                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>


            </div>
            <button type="button" title="Remove"
                class="removeMb d-md-none d-inline-block text-decoration-underline border-0"
                wire:click="save_for_later(<?php echo e($cartItem->product_variant_id); ?>)"><?php echo e(labels('front_messages.save_for_later', 'Save for Later')); ?></button>
            <button type="button" title="Remove"
                class="removeMb d-md-none d-inline-block text-decoration-underline border-0"
                wire:click="remove_from_cart(<?php echo e($cartItem->product_variant_id); ?>)"><?php echo e(labels('front_messages.remove', 'Remove')); ?></button>
        </td>
        <td class="cart-price cart-flex-item text-center small-hide">
            <?php
                $priceToUse =
                    $cartItem->comboProduct->special_price && $cartItem->comboProduct->special_price > 0
                        ? $cartItem->comboProduct->special_price
                        : $cartItem->comboProduct->price;
                $cart_total = $priceToUse * $cartItem->qty;
            ?>
            <span class="money fw-500"><?php echo e(app(CurrencyService::class)->currentCurrencyPrice($cart_total, true)); ?></span>
        </td>

    </tr>
<?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
<?php /**PATH /home/solarmar/solarmart-web.neuromonk.co.in/resources/views/components/utility/cart/CardOne.blade.php ENDPATH**/ ?>