<?php
use App\Services\TranslationService;
use App\Services\CartService;
use App\Services\StoreService;
use App\Services\MediaService;
use App\Models\Store;
$store_id = session('store_id');
$store_details = app(StoreService::class)->getCurrentStoreData($store_id);
$store_details = json_decode($store_details) ?? '';
$language_code = app(TranslationService::class)->getLanguageCode();
$menuCategories = collect($categories['categories'] ?? [])->map(fn($category) => (object) $category);
?>
<style>
    .mobile-nav-wrapper {
    position: fixed;
    top: 0;
    left: -100%;
    width: 280px;
    height: 100%;
    background: #fff;
    z-index: 9999;
    transition: all 0.3s ease;
    overflow-y: auto;
}

.mobile-nav-wrapper.active {
    left: 0;
}

.mobile-search-overlay {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: #fff;
    z-index: 10000;
    display: none;
    flex-direction: column;
}

.mobile-search-header {
    display: flex;
    align-items: center;
    padding: 15px;
    border-bottom: 1px solid #eee;
}

.mobile-search-header .back-btn {
    background: none;
    border: none;
    font-size: 24px;
    margin-right: 15px;
    display: flex;
    align-items: center;
    color: #666;
}

.mobile-search-header .title {
    font-size: 18px;
    font-weight: 500;
    color: #333;
}

.mobile-search-body {
    padding: 15px;
    flex: 1;
    overflow-y: auto;
}

    .top-header-bg {
       background-color: var(--primary-color);
        /* ✅ Deep green shade */
        color: #fff;
    }
    .top-header{
        padding-bottom: 3px !important;
        padding-top: 3px !important;
    }

    /* .products-dropdown .megamenu {
        min-width: 520px;
        padding: 24px;
    }
    .products-dropdown .dropdown-title {
        font-weight: 600;
        display: block;
        padding: 4px 0;
        color: #041632;
        text-decoration: none;
    }
    .products-dropdown .dropdown-title:hover {
        color: #5dc943;
    } */
    /* Remove large gaps between li elements */
    .products-dropdown {
        position: relative;
    }

    .products-dropdown .megamenu {
        position: absolute;
        top: 100%;
        left: 0;
        min-width: 260px;
        max-width: 600px;
        padding: 12px;
        z-index: 999;
    }

    .products-dropdown .megamenu .row {
        margin: 0 !important;
        width: 100%;
    }

    html,
    body {
        overflow-x: hidden;
    }

    /* Vertical Megamenu Styles */
    .vertical-megamenu-wrapper {
        position: relative;
    }

    .vertical-megamenu {
        position: absolute;
        top: 100%;
        left: 0;
        background: #fff;
        box-shadow: 0 4px 10px rgba(0,0,0,0.1);
        min-width: 250px;
        display: none;
        z-index: 1000;
        border-radius: 4px;
        padding: 10px 0;
    }

    .lvl1.parent:hover > .vertical-megamenu {
        display: block;
    }

    .vertical-menu-item {
        position: relative;
        list-style: none;
    }

    .vertical-menu-link {
        display: block;
        padding: 10px 20px;
        color: #333;
        text-decoration: none;
        transition: all 0.3s;
        font-weight: 500;
    }

    .vertical-menu-item:hover > .vertical-menu-link {
        background-color: #f8f9fa;
        color: #5dc943;
    }

    .submenu-panel {
        position: absolute;
        top: 0;
        left: 100%;
        background: #fff;
        box-shadow: 4px 4px 10px rgba(0,0,0,0.1);
        min-width: 250px;
        height: 100%;
        min-height: 200px;
        display: none;
        border-right: 1px solid #eee;
        padding: 10px 0;
        border-radius: 0 4px 4px 0;
    }

    .vertical-menu-item:hover > .submenu-panel {
        display: block;
    }

    .submenu-panel .vertical-menu-link:hover {
        color: #5dc943;
    }

    /* Tablet/iPad Pro Fixes (1024px) */
    @media only screen and (min-width: 992px) and (max-width: 1200px) {
        .site-nav > li > a {
            padding: 0 8px !important;
            font-size: 13px !important;
        }
        .header-cart, .wishlist-link, .account-parent {
            margin-left: 8px !important;
        }
        .icons-col {
            padding-left: 5px !important;
            padding-right: 5px !important;
        }
    }
</style>
<div>

    <input type="hidden" id="store-primary-color" name="store-primary-color"
        value="<?php echo e($store_details[0]->primary_color ?? '#041632'); ?>">
    <input type="hidden" id="store-secondary-color" name="store-secondary-color"
        value="<?php echo e($store_details[0]->secondary_color ?? '#f4a51c'); ?>">
    <input type="hidden" id="store-link-active-color" name="store-link-active-color"
        value="<?php echo e($store_details[0]->active_color ?? '#041632'); ?>">
    <input type="hidden" id="store-link-hover-color" name="store-link-hover-color"
        value="<?php echo e($store_details[0]->hover_color ?? '#f4a51c'); ?>">
    <div class="top-header top-header-bg">
        <div class="container-fluid ">
            <div class="row align-items-center justify-content-between">
                <div class="col-6 col-sm-6 col-md-3 col-lg-4 text-left d-flex">
                    <ion-icon wire:ignore class="fs-5 me-2" name="call-outline"></ion-icon><a style="color: #fff;"
                        href="tel:<?php echo e($settings->support_number); ?>"><?php echo e($settings->support_number); ?> </a>
                </div>
                
                <div class="col-6 col-sm-6 col-md-3 col-lg-4 text-right d-flex align-items-center justify-content-end">
                    <!-- <li class="lvl1 parent megamenu"> -->
                    <a wire:navigate
                          href="<?php echo e(customUrl('calculator')); ?>">
                        <span class="hover:text-white cursor-pointer text-white"><?php echo e(labels('front_messages.calculator', 'Calculator')); ?></span>
                    </a>
                    <!-- </li>     -->
                    <div class="select-wrap language-picker float-start">

                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(count($languages) > 1): ?>
                        <ul class="default-option">
                            <li>
                                <div class="option english">
                                    <span><?php echo e(session('locale') ?? ($languages[0]->code ?? 'en')); ?></span>
                                </div>
                            </li>
                        </ul>
                        <?php else: ?>
                        <div class="option english">
                            <span><?php echo e(session('locale') ?? ($languages[0]->code ?? 'en')); ?></span>
                        </div>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(count($languages) > 1): ?>
                        <ul class="select-ul">
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="option english changeLang" data-lang-code="<?php echo e($language->code); ?>">
                                <div>
                                    <span><?php echo e($language->code); ?></span>
                                </div>
                            </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            <li>
                        </ul>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                    </div>
                    


        </div>
    </div>
</div>
</div>
<!--End Top Header-->

<!--Header-->
<header  class="header d-flex align-items-center header-1 header-fixed">
    <div id="app_url" data-app-url="<?php echo e(route('home')); ?>"></div>
    <div class="container-fluid">
        <div class="row">
            
            <?php
            $img =
            !empty($store_details[0]->half_store_logo) &&
            file_exists(
            public_path(config('constants.STORE_IMG_PATH') . $store_details[0]->half_store_logo),
            )
            ? app(MediaService::class)->getImageUrl(
            $store_details[0]->half_store_logo,
            '',
            '',
            'image',
            'STORE_IMG_PATH',
            )
            : app(MediaService::class)->getImageUrl($settings->logo);
            $img = app(MediaService::class)->dynamic_image($img, 150);
            ?>
            <!--Logo-->
            <div class="logo col-4 col-lg-2 align-self-center">
                <a wire:navigate href="<?php echo e(customUrl('home')); ?>"><img style="width: 120px; height: auto; max-height: 80px; object-fit: contain;" src="<?php echo e($img); ?>"
                        alt="<?php echo e($settings->site_title); ?>" title="<?php echo e($settings->site_title); ?>" /></a>
            </div>

            <!--End Logo-->
            <!--Menu-->
            <div class="col-1 col-sm-2 col-md-2 col-lg-4 align-self-center d-menu-col d-none d-lg-block">
                <nav class="navigation" id="AccessibleNav">
                    <ul id="siteNav" class="site-nav medium center">
                        <li class="lvl1 parent dropdown"><a wire:navigate
                                href="<?php echo e(customUrl('home')); ?>"><?php echo e(labels('front_messages.home', 'Home')); ?> </a>
                        </li>


                        <li class="lvl1 parent products-dropdown vertical-megamenu-wrapper">
                            <a wire:navigate href="<?php echo e(customUrl('products')); ?>"><?php echo e(labels('front_messages.products', 'Products')); ?></a>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($menuCategories->count() >= 1): ?>
                                <ul class="vertical-megamenu">
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $menuCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="vertical-menu-item">
                                            <a wire:navigate href="<?php echo e(customUrl('categories/' . $category->slug . '/products')); ?>" class="vertical-menu-link d-flex justify-content-between align-items-center">
                                                <?php echo e($category->name); ?>

                                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!empty($category->children)): ?>
                                                    <ion-icon name="chevron-forward-outline" class="fs-6"></ion-icon>
                                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                            </a>
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!empty($category->children)): ?>
                                                <ul class="submenu-panel">
                                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $category->children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php
                                                            $child = (object)$child;
                                                        ?>
                                                        <li class="vertical-menu-item">
                                                            <a wire:navigate href="<?php echo e(customUrl('categories/' . $child->slug . '/products')); ?>" class="vertical-menu-link d-flex justify-content-between align-items-center">
                                                                <?php echo e($child->name); ?>

                                                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!empty($child->children)): ?>
                                                                    <ion-icon name="chevron-forward-outline" class="fs-6"></ion-icon>
                                                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                            </a>
                                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!empty($child->children)): ?>
                                                                <ul class="submenu-panel">
                                                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $child->children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $grandchild): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <?php
                                                                            $grandchild = (object)$grandchild;
                                                                        ?>
                                                                        <li class="vertical-menu-item">
                                                                            <a wire:navigate href="<?php echo e(customUrl('categories/' . $grandchild->slug . '/products')); ?>" class="vertical-menu-link">
                                                                                <?php echo e($grandchild->name); ?>

                                                                            </a>
                                                                        </li>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                                </ul>
                                                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                        </li>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                </ul>
                                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </ul>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </li>
                        <li class="lvl1 parent megamenu"><a wire:navigate
                                href="<?php echo e(customUrl('combo-products')); ?>"><?php echo e(labels('front_messages.combo_products', 'Combos ')); ?>

                            </a>
                        </li>
                    </ul>
                </nav>
            </div>

            <!--End Menu-->

            <!-- Mobile Icons (Search + Menu) d-lg-none -->
            <div class="col-8 col-lg-8 align-self-center  d-lg-none">
                <div class="d-flex justify-content-end align-items-center gap-2">
                    <!-- Mobile Search Icon -->
                    <div class="iconset pe-0 search-icon-mobile" title="Search">
                        <ion-icon wire:ignore class="fs-5" name="search-outline"></ion-icon>
                    </div>

                    <!--Mobile Menu Toggle-->
                    <button type="button"
                        class="iconset pe-0 menu-icon js-mobile-nav-toggle mobile-nav--open"
                        title="Menu"><ion-icon wire:ignore class="fs-5" name="menu"></ion-icon></button>

                    <!--End Mobile Toggle-->
                </div>
            </div>
            <!-- End Mobile Icons -->

             <!-- Desktop Search bar -->
            <div class="col-12 col-md-3 col-lg-3 align-self-center mt-2 mt-lg-0 d-none d-lg-block">
              <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('header.search-product', []);

$key = null;

$key ??= \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::generateKey('lw-1288782593-0', null);

$__html = app('livewire')->mount($__name, $__params, $key);

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
            </div>

            <!-- Mobile Search Overlay -->
            <div class="mobile-search-overlay">
                <div class="mobile-search-header">
                    <button type="button" class="back-btn search-close-mobile">
                        <ion-icon name="arrow-back-outline"></ion-icon>
                    </button>
                    <span class="title">Search</span>
                </div>
                <div class="mobile-search-body">
                    <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('header.search-product', []);

$key = null;

$key ??= \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::generateKey('lw-1288782593-1', null);

$__html = app('livewire')->mount($__name, $__params, $key);

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                </div>
            </div>
            <!-- End Search bar -->
            <!--Right Icon-->
            <div class="col-7 col-sm-9 col-md-9 col-lg-3 align-self-center icons-col text-right d-none d-lg-block">
                <!--Search-->
                
                <!--End Search-->

                <?php
                $cart_count = '0';
                ?>
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(auth()->guard()->check()): ?>
                <?php

                $user_id = auth()->id() ?? 0;
                $store_id = session('store_id') ?? '';
                $favorites = getFavorites(user_id: $user_id, store_id: $store_id);
                $cart_count = app(CartService::class)->getCartCount($user_id, $store_id);
                ?>
                <!--Wishlist-->
                <div class="wishlist-link iconset" title="Wishlist"><a wire:navigate
                        href="<?php echo e(customUrl('my-account.favorites')); ?>" class="text-black"><i
                            class="anm anm-heart anm-heart-l hdr-icon icon"></i><span
                            class="wishlist-count"><?php echo e($favorites['favorites_count']); ?></span></a>
                </div>
                <!--End Wishlist-->
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                <!--Minicart-->
                <div class="header-cart iconset" title="Cart">
                    <a href="#;" class="header-cart btn-minicart clr-none" data-bs-toggle="offcanvas"
                        data-bs-target="#minicart-drawer"><i class="hdr-icon icon anm anm-cart-l"></i><span
                            class="cart-count"><?php echo e($cart_count); ?></span></a>
                </div>
                <!--End Minicart-->
                  <!--Account-->
                <div class="account-parent iconset ">



                     <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(auth()->guard()->check()): ?>
                      <div class="account-link" title="Account"><i class="hdr-icon icon anm anm-user-al"></i></div>

                     <?php else: ?>
                      <div class="account-link" >
                        <Button type="button" class="btn btn-btn" data-bs-toggle="modal" >Login
                        </button>
                    </div>

                     <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    <div id="accountBox">
                        <div class="customer-links">
                            <ul class="m-0">
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(auth()->guard()->check()): ?>

                                <li><a href="<?php echo e(customUrl('my-account')); ?>" wire:navigate><i
                                            class="hdr-icon icon anm anm-user-al"></i><?php echo e(labels('front_messages.my_account', 'My Account')); ?></a>
                                </li>
                                <li><a href="<?php echo e(customUrl('orders')); ?>" wire:navigate><i
                                            class="anm anm-bag-l hdr-icon icon"></i><?php echo e(labels('front_messages.my_orders', 'My Orders')); ?></a>
                                </li>
                                
                                <li><a class="logout"><i
                                            class="anm anm-arrow-al-left hdr-icon icon"></i><?php echo e(labels('front_messages.sign_out', 'Sign out')); ?></a>
                                </li>
                                <?php else: ?>
                                <li><a href="javascript:void(0)" data-bs-toggle="modal" data-bs-target="#loginModal"><i
                                            class="anm anm-arrow-al-right anm-user-al hdr-icon icon"></i><?php echo e(labels('front_messages.sign_in', 'Login as Customer')); ?></a>
                                </li>
                                 <li>
                                    <a href="https://solarmart.neuromonk.co.in/seller/login">
                                       <i class="anm anm-arrow-al-right anm-user-al hdr-icon icon"></i><?php echo e(labels('front_messages.sign_in', 'Login as Seller')); ?>

                                    </a>
                                </li>
                                
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </ul>
                        </div>
                    </div>
                </div>
                <!--End Account-->
                <!--Mobile Toggle-->
                <!-- <button type="button"
                    class="iconset pe-0 menu-icon js-mobile-nav-toggle mobile-nav--open d-lg-none"
                    title="Menu"><ion-icon wire:ignore class="fs-5" name="menu"></ion-icon></button> -->
                <!--End Mobile Toggle-->
            </div>
            <!--End Right Icon-->
        </div>
    </div>
</header>
<!--End Header-->

<!-- Login Modal -->
<div class="modal fade" id="loginModal" tabindex="-1" aria-labelledby="loginModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content rounded-4 border-0 shadow-lg">
            <div class="modal-header border-0 pb-0">
                <button type="button" class="btn-close shadow-none" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body p-4 pt-0">
                <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('RegisterAndLogin.Login', ['isModal' => true]);

$key = null;

$key ??= \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::generateKey('lw-1288782593-2', null);

$__html = app('livewire')->mount($__name, $__params, $key);

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
            </div>
        </div>
    </div>
</div>

<!-- Register Modal -->
<div class="modal fade" id="registerModal" tabindex="-1" aria-labelledby="registerModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content rounded-4 border-0 shadow-lg">
            <div class="modal-header border-0 pb-0">
                <button type="button" class="btn-close shadow-none" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body p-4 pt-0">
                <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('RegisterAndLogin.Register', ['isModal' => true]);

$key = null;

$key ??= \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::generateKey('lw-1288782593-3', null);

$__html = app('livewire')->mount($__name, $__params, $key);

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
            </div>
        </div>
    </div>
</div>

<!-- Forgot Password Modal -->
<div class="modal fade" id="forgotPasswordModal" tabindex="-1" aria-labelledby="forgotPasswordModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content rounded-4 border-0 shadow-lg">
            <div class="modal-header border-0 pb-0">
                <button type="button" class="btn-close shadow-none" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body p-4 pt-0">
                <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('RegisterAndLogin.ForgetPassword', ['isModal' => true]);

$key = null;

$key ??= \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::generateKey('lw-1288782593-4', null);

$__html = app('livewire')->mount($__name, $__params, $key);

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
            </div>
        </div>
    </div>
</div>

<!--Mobile Menu-->
<div class="mobile-nav-wrapper"  >
    <div class="closemobileMenu"><?php echo e(labels('front_messages.close_menu', 'Close Menu')); ?><ion-icon
            name="close-outline" class="icon"></ion-icon></div>
    <ul id="MobileNav" class="mobile-nav">
        <li class="lvl1 parent dropdown"><a
                href="<?php echo e(customUrl('home')); ?>"><?php echo e(labels('front_messages.home', 'Home')); ?></a>
        </li>
        <li class="lvl1 parent dropdown">
            <a href="<?php echo e(customUrl('products')); ?>" ><?php echo e(labels('front_messages.products', 'Products')); ?> <span class="anm anm-angle-down-l" style="float: right;"></span></a>
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($menuCategories->count() >= 1): ?>
            <ul class="sub-menu" style="display: none;">
                <li><a wire:navigate href="<?php echo e(customUrl('products')); ?>"><?php echo e(labels('front_messages.all_products', 'All Products')); ?></a></li>
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $menuCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li>
                    <a wire:navigate href="<?php echo e(customUrl('categories/' . $category->slug . '/products')); ?>">
                        <?php echo e($category->name); ?>

                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!empty($category->children)): ?>
                        <span class="anm anm-angle-down-l" style="float: right;"></span>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </a>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!empty($category->children)): ?>
                    <ul class="sub-menu" style="display: none;">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $category->children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php $child = (object)$child; ?>
                        <li>
                            <a wire:navigate href="<?php echo e(customUrl('categories/' . $child->slug . '/products')); ?>">
                                <?php echo e($child->name); ?>

                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!empty($child->children)): ?>
                                <span class="anm anm-angle-down-l" style="float: right;"></span>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </a>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!empty($child->children)): ?>
                            <ul class="sub-menu" style="display: none;">
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $child->children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $grandchild): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php $grandchild = (object)$grandchild; ?>
                                <li>
                                    <a wire:navigate href="<?php echo e(customUrl('categories/' . $grandchild->slug . '/products')); ?>">
                                        <?php echo e($grandchild->name); ?>

                                    </a>
                                </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </ul>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </ul>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </ul>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </li>
        <li class="lvl1 parent megamenu"><a wire:navigate
                 href="<?php echo e(customUrl('combo-products')); ?>"><?php echo e(labels('front_messages.combo_products', 'Combos ')); ?>

            </a>
        </li>
        
        
        <li class="lvl1 parent dropdown"><a wire:navigate
                href="<?php echo e(customUrl('contact_us')); ?>"><?php echo e(labels('front_messages.contact_us', 'Contact Us')); ?>

            </a>
        </li>
        <li class="lvl1 parent dropdown"><a wire:navigate
                href="<?php echo e(customUrl('faqs')); ?>"><?php echo e(labels('front_messages.faqs', 'FAQs')); ?> </a>
        </li>
        <!-- <li class="lvl1 parent dropdown"><a wire:navigate
                    href="<?php echo e(customUrl('blogs')); ?>"><?php echo e(labels('front_messages.blogs', 'Blogs')); ?> </a>
            </li> -->

        <li class="mobile-menu-bottom">
            <div class="mobile-links">
                <ul class="list-inline d-inline-flex flex-column w-100">
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(auth()->guard()->check()): ?>
                    <li><a href="<?php echo e(customUrl('my-account')); ?>" wire:navigate
                            class="d-flex align-items-center"><i
                                class="hdr-icon icon anm anm-user-al"></i><?php echo e(labels('front_messages.my_account', 'My Account')); ?></a>
                    </li>
                     <li><a href="<?php echo e(route('Profile_logout')); ?>" wire:navigate
                            class="d-flex align-items-center"><i
                                class="hdr-icon icon anm anm-user-al"></i><?php echo e(labels('front_messages.log_out', 'Log Out')); ?></a>
                    </li>
                    <?php else: ?>
                    <li><a href="javascript:void(0)" data-bs-toggle="modal" data-bs-target="#loginModal" class="d-flex align-items-center"><i
                                class="anm anm-arrow-al-right anm-user-al hdr-icon icon"></i><?php echo e(labels('front_messages.sign_in', 'Login as Customer')); ?></a>
                    </li>
                    <li>
                     <a href="https://solarmart.neuromonk.co.in/seller/login" class="d-flex align-items-center">
                         <i class="anm anm-arrow-al-right anm-user-al hdr-icon icon"></i><?php echo e(labels('front_messages.sign_in', 'Login as Seller')); ?>

                     </a>
                    </li>
                    <li><a href="javascript:void(0)" data-bs-toggle="modal" data-bs-target="#registerModal" class="d-flex align-items-center"><i
                                class="hdr-icon icon anm anm-user-al"></i><?php echo e(labels('front_messages.register', 'Register as Customer')); ?></a>
                    </li>
                     <li>
                     <a href="https://solarmart.neuromonk.co.in/seller/register" class="d-flex align-items-center">
                         <i class="hdr-icon icon anm anm-user-al"></i><?php echo e(labels('front_messages.sign_in', 'Register as Seller')); ?>

                     </a>
                    </li>

                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    <li class="title h5"><?php echo e(labels('front_messages.need_help', 'Need Help?')); ?></li>
                    <li><a href="tel:401234567890" class="d-flex align-items-center"><ion-icon
                                name="call-outline" class="me-1"></ion-icon>
                            <?php echo e($settings->support_number); ?></a></li>
                    <li><a href="mailto:info@example.com" class="d-flex align-items-center"><ion-icon
                                name="mail-outline" class="me-1"></ion-icon> <?php echo e($settings->support_email); ?></a>
                    </li>
                </ul>
            </div>
            
        </li>
    </ul>
</div>




<?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('pages.model-cart', []);

$key = null;

$key ??= \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::generateKey('lw-1288782593-5', null);

$__html = app('livewire')->mount($__name, $__params, $key);

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
<?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(isset($stores) &&
count($stores) >= 1 &&
url()->full() == customUrl(url()->full()) &&
session()->get('show_store_popup')): ?>
<div class="newsletter-modal modal fade" id="store_select_modal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content border-0">
            <div class="modal-body p-0">
                <button type="button" class="btn-close" data-bs-dismiss="modal"
                    aria-label="Close"></button>
                <div class="newsletter-wrap d-flex flex-column">
                    <div class="newsltr-text text-center store-popup-box">
                        <div class="wraptext mw-100">
                            <h6 class="title text-transform-none">
                                <?php echo e(labels('front_messages.please_choose_store.', 'Please choose a store.')); ?>

                            </h6>
                            <p class="text">
                                <?php echo e(labels('front_messages.pick_store_that_suits_your_requirements', 'Pick a Store that Suits Your Requirements.')); ?>

                            </p>
                            <div class="collection-style1 row row-cols-2 row-cols-lg-3 mt-0">
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(count($stores) >= 1): ?>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $stores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $store): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                $store_img = route('front_end.dynamic_image', [
                                'url' => app(MediaService::class)->getMediaImageUrl(
                                $store->image,
                                'STORE_IMG_PATH',
                                ),
                                'width' => 400,
                                'quality' => 90,
                                ]);
                                $store_name = app(TranslationService::class)->getDynamicTranslation(
                                Store::class,
                                'name',
                                $store->id,
                                $language_code,
                                );
                                ?>
                                <div class="category-item zoomscal-hov">
                                    <a data-store-id="<?php echo e($store->id); ?>"
                                        data-store-name="<?php echo e($store_name); ?>"
                                        data-store-slug="<?php echo e($store->slug); ?>"
                                        data-store-image="<?php echo e($store_img); ?>"
                                        class="category-link select-store clr-none cursor-pointer">
                                        <div class="zoom-scal zoom-scal-nopb brands-image">
                                            <img class="blur-up lazyload w-100"
                                                data-src="<?php echo e($store_img); ?>"
                                                src="<?php echo e($store_img); ?>" alt="<?php echo e($store_name); ?>"
                                                title="<?php echo e($store_name); ?>" />
                                        </div>
                                        <div
                                            class="details mt-3 d-flex justify-content-center align-items-center">
                                            <h4 class="category-title mb-0">
                                                <?php echo e($store_name); ?>

                                            </h4>
                                        </div>
                                    </a>
                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>
                            
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
<style>
    #nprogress .bar {
        background: <?= $store_details[0]->secondary_color ?? '#f4a51c' ?> !important;
        z-index: 1111;
    }

    .swiper-pagination-bullet-active-main {
        background: <?= $store_details[0]->secondary_color ?? '#f4a51c' ?> !important;
    }
</style>
<style>
    /* Force body overflow hidden when modal is open */
    body.modal-open-fix {
        overflow: hidden !important;
        height: 100vh !important;
    }
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const modals = ['loginModal', 'registerModal'];

    modals.forEach(modalId => {
        const modalEl = document.getElementById(modalId);
        if (modalEl) {
            modalEl.addEventListener('show.bs.modal', function () {
                document.body.classList.add('modal-open-fix');
            });

            modalEl.addEventListener('hidden.bs.modal', function () {
                document.body.classList.remove('modal-open-fix');
            });
        }
    });

        // Use event delegation for mobile search toggles to survive Livewire re-renders
        $(document).on('click', '.search-icon-mobile', function() {
            // Close mobile menu if it's open
            $('.mobile-nav-wrapper').removeClass('active');

            $('.mobile-search-overlay').css('display', 'flex');
            $('body').addClass('modal-open-fix');

            // Focus on search input when opened
            setTimeout(function() {
                $('.mobile-search-overlay input[type="text"]').focus();
            }, 100);
        });

        $(document).on('click', '.search-close-mobile', function() {
            $('.mobile-search-overlay').hide();
            $('body').removeClass('modal-open-fix');
        });

        // Close search overlay when a product is clicked in results
        $(document).on('click', '.mobile-search-body .search-result-item a', function() {
            $('.mobile-search-overlay').hide();
            $('body').removeClass('modal-open-fix');
        });

});
</script>
<?php if(isset($stores) &&
count($stores) >= 2 &&
url()->full() == customUrl(url()->full()) &&
session()->get('show_store_popup')): ?>
<?php
session()->put('show_store_popup', false);
?>
<script>
    setTimeout(function() {
        $('#store_select_modal').modal("show");
    }, 2000);
</script>
<?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
</div>
<!-- <script>
function initMobileMenu() {

    const openBtn = document.querySelector(".js-mobile-nav-toggle");
    const mobileWrapper = document.querySelector(".mobile-nav-wrapper");
    const closeBtn = document.querySelector(".closemobileMenu");

    // Remove old listeners by cloning (important fix)
    if (openBtn) {
        const newOpenBtn = openBtn.cloneNode(true);
        openBtn.parentNode.replaceChild(newOpenBtn, openBtn);

        newOpenBtn.addEventListener("click", function () {
            mobileWrapper.classList.add("active");
        });
    }

    if (closeBtn) {
        const newCloseBtn = closeBtn.cloneNode(true);
        closeBtn.parentNode.replaceChild(newCloseBtn, closeBtn);

        newCloseBtn.addEventListener("click", function () {
            mobileWrapper.classList.remove("active");
        });
    }

    // Submenu toggle (multi-level)
    const allLinks = document.querySelectorAll("#MobileNav a");

    allLinks.forEach(function (link) {

        const newLink = link.cloneNode(true);
        link.parentNode.replaceChild(newLink, link);

        newLink.addEventListener("click", function (e) {

            const nextEl = this.nextElementSibling;

            if (nextEl && nextEl.classList.contains("sub-menu")) {
                e.preventDefault();

                if (nextEl.style.display === "block") {
                    nextEl.style.display = "none";
                } else {
                    nextEl.style.display = "block";
                }
            }
        });
    });
}

/* Run first time */
document.addEventListener("DOMContentLoaded", function () {
    initMobileMenu();
});

/* VERY IMPORTANT: run again after Livewire page change */
document.addEventListener("livewire:navigated", function () {
    initMobileMenu();
});
</script> -->
<script>
function initMobileMenu() {

    const openBtn = document.querySelector(".js-mobile-nav-toggle");
    const mobileWrapper = document.querySelector(".mobile-nav-wrapper");
    const closeBtn = document.querySelector(".closemobileMenu");

    // Open menu
    if (openBtn) {
        const newOpenBtn = openBtn.cloneNode(true);
        openBtn.parentNode.replaceChild(newOpenBtn, openBtn);

        newOpenBtn.addEventListener("click", function () {
            mobileWrapper.classList.add("active");
        });
    }

    // Close menu button
    if (closeBtn) {
        const newCloseBtn = closeBtn.cloneNode(true);
        closeBtn.parentNode.replaceChild(newCloseBtn, closeBtn);

        newCloseBtn.addEventListener("click", function () {
            mobileWrapper.classList.remove("active");
        });
    }

    // Handle all menu clicks
    const allLinks = document.querySelectorAll("#MobileNav a");

    allLinks.forEach(function (link) {

        const newLink = link.cloneNode(true);
        link.parentNode.replaceChild(newLink, link);

        newLink.addEventListener("click", function (e) {

            const nextEl = this.nextElementSibling;

            // If submenu exists → toggle only (do not close menu)
            if (nextEl && nextEl.classList.contains("sub-menu")) {
                e.preventDefault();

                if (nextEl.style.display === "block") {
                    nextEl.style.display = "none";
                } else {
                    nextEl.style.display = "block";
                }

            } else {
                // Normal link → close menu after navigation click
                mobileWrapper.classList.remove("active");
            }
        });
    });
}

/* First load */
document.addEventListener("DOMContentLoaded", function () {
    initMobileMenu();
});

/* After Livewire navigation */
document.addEventListener("livewire:navigated", function () {
    initMobileMenu();
});
</script>




<?php /**PATH /home/solarmar/solarmart-web.neuromonk.co.in/resources/views/components/header/header.blade.php ENDPATH**/ ?>