<div id="minicart-drawer" wire:ignore.self x-data="{ agreed: false }" x-init="$el.addEventListener('hidden.bs.offcanvas', () => { agreed = false })" class="minicart-right-drawer offcanvas offcanvas-end" tabindex="-1">
    <?php
        use App\Models\Product;
        use App\Models\ComboProduct;
        use App\Services\TranslationService;
        use App\Services\MediaService;
        use App\Services\CurrencyService;
    ?>
    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(count($cart_data) < 1): ?>
        <!--MiniCart Empty-->
        <div id="cartEmpty" class="cartEmpty d-flex-justify-center flex-column text-center p-3 text-muted">
            <div class="minicart-header d-flex-center justify-content-between w-100">
                <h4 class="fs-6"><?php echo e(labels('front_messages.your_cart', 'Your cart')); ?> (<span
                        class="cart_count">0</span> <?php echo e(labels('front_messages.items', 'Items')); ?>)</h4>
                <button class="close-cart border-0" data-bs-dismiss="offcanvas" aria-label="Close"><ion-icon
                        name="close-outline" class="icon" data-bs-toggle="tooltip" data-bs-placement="left"
                        title="Close"></ion-icon></button>
            </div>
            <div id="display_cart">
                <div class="cartEmpty-content mt-4">
                    <ion-icon name="cart-outline" class="icon text-muted fs-1"></ion-icon>
                    <p class="my-3"><?php echo e(labels('front_messages.no_products_in_cart', 'No Products in the Cart')); ?></p>
                    <!-- <a href="<?php echo e(customUrl('products')); ?>"
                        class="btn btn-primary cart-btn"><?php echo e(labels('front_messages.continue_shopping', 'Continue shopping dsjfkldj')); ?></a> -->
                    <a href="<?php echo e(customUrl('products')); ?>"
                    onclick="window.location.href='<?php echo e(customUrl('products')); ?>'; return false;"
                    class="btn btn-primary cart-btn">
                    Continue shopping
                    </a>

                </div>
            </div>
        </div>
        <!--End MiniCart Empty-->
    <?php else: ?>
        <!--MiniCart Content-->
        <div id="cart-drawer" class="block block-cart">
            <div class="minicart-header">
                <button wire:ignore class="close-cart border-0" data-bs-dismiss="offcanvas" aria-label="Close">
                    <ion-icon class="icon" data-bs-toggle="tooltip" data-bs-placement="left"
                        name="close-outline"></ion-icon></button>
                <h4 class="fs-6"><?php echo e(labels('front_messages.your_cart', 'Your cart')); ?>

                    (<?php echo e(count($cart_data['cart_items'])); ?> <?php echo e(labels('front_messages.items', 'Items')); ?>)</h4>
            </div>
            
            <div class="minicart-content">
                <ul class="m-0 clearfix">
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $cart_data['cart_items']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $items): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $language_code = app(TranslationService::class)->getLanguageCode();
                            $product_name = '';
                            $product_type = $items->cart_product_type;
                            if ($items->cart_product_type == 'combo') {
                                $product_name = app(TranslationService::class)->getDynamicTranslation(
                                    ComboProduct::class,
                                    'title',
                                    $items->product_variant_id,
                                    $product_type,
                                    $language_code,
                                );
                                $pro_image = app(MediaService::class)->dynamic_image($items->comboProduct->image, 70);
                            } else {
                                $product_name = app(TranslationService::class)->getDynamicTranslation(
                                    Product::class,
                                    'name',
                                    $items->product->id,
                                    $product_type,
                                    $language_code,
                                );
                                $pro_image = app(MediaService::class)->dynamic_image($items->product->image, 70);
                            }

                        ?>
                        <li class="item d-flex justify-content-center align-items-center">
                        <?php
                                $slug = $items->cart_product_type == 'combo' ? $items->comboProduct->slug : $items->product->slug;
                                $prefix = $items->cart_product_type == 'combo' ? 'combo-products/' : 'products/';
                        ?>

                            <a class="product-image rounded-3" wire:navigate
                                href="<?php echo e(customUrl($prefix . $slug)); ?>">
                                <img class="blur-up lazyload" data-src="<?php echo e($pro_image); ?>" src="<?php echo e($pro_image); ?>"
                                    alt="<?php echo e($product_name); ?>" title="<?php echo e($product_name); ?>"  />
                            </a>

                            <div class="product-details">
                                <div class="product-title-container" x-data="{ expanded: false, isOverflown: false }" x-init="$nextTick(() => { isOverflown = $refs.title.scrollHeight > $refs.title.clientHeight })">
                                    <a x-ref="title" class="" wire:navigate
                                        href="<?php echo e(customUrl($prefix . $slug)); ?>"
                                        :style="expanded ? 'display: block; white-space: normal;' : 'display: -webkit-box; -webkit-line-clamp: 2; -webkit-box-orient: vertical; overflow: hidden; text-overflow: ellipsis;'"
                                    ><?php echo e($product_name); ?></a>
                                    <span x-show="isOverflown" @click="expanded = !expanded" class="read-more-toggle text-primary pointer" style="cursor: pointer; font-size: 13px; font-weight: 500; display: inline-block; margin-top: 2px;">
                                        <span x-show="!expanded">... read more</span>
                                        <span x-show="expanded"> show less</span>
                                    </span>
                                </div>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($items->cart_product_type != 'combo'): ?>
                                    <div class="variant-cart my-2">
                                        <?php echo e($items['product_variants'][0]['variant_values']); ?>

                                    </div>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                <div class="priceRow">
                                    <div class="product-price">
                                        <?php
                                            if ($items->cart_product_type == 'combo') {
                                                $price = app(CurrencyService::class)->currentCurrencyPrice(
                                                    $items->comboProduct->price ?? 0,
                                                    true,
                                                );
                                                $special_price =
                                                    $items->comboProduct->special_price &&
                                                    $items->comboProduct->special_price > 0
                                                        ? app(CurrencyService::class)->currentCurrencyPrice(
                                                            $items->comboProduct->special_price,
                                                            true,
                                                        )
                                                        : $price;
                                            } else {
                                                $price = app(CurrencyService::class)->currentCurrencyPrice(
                                                    $items->productVariant->price,
                                                    true,
                                                );
                                                $special_price =
                                                    $items->productVariant->special_price &&
                                                    $items->productVariant->special_price > 0
                                                        ? app(CurrencyService::class)->currentCurrencyPrice(
                                                            $items->productVariant->special_price,
                                                            true,
                                                        )
                                                        : $price;
                                            }
                                        ?>

                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($special_price !== $price): ?>
                                            <span class="price old-price"><?php echo e($price); ?></span>
                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        <span class="price"><?php echo e($special_price); ?></span>
                                    </div>
                                </div>

                            </div>
                            <?php
                                $productData = $items->cart_product_type == 'combo' ? $items->comboProduct : $items->product;
                            ?>
                             <?php
                              
                                $cartQty  = $productData->cart_qty ?? $productData->qty ?? $productData->minimum_order_quantity;
                            ?>

                            <div class="qtyDetail text-end cart-qtyDetail">
                                <div class="qtyField">
                                    <button wire:ignore class="qtyBtn minus" href="#;">
                                        <ion-icon name="remove-outline"></ion-icon>
                                    </button>

                                    <input type="number" name="quantity" value="<?php echo e($cartQty); ?>" class="qty"
                                        max='<?php echo e($productData->total_allowed_quantity == 0 ? 'Infinity' : $productData->total_allowed_quantity); ?>'
                                        step='<?php echo e($productData->quantity_step_size); ?>'
                                        min='<?php echo e($productData->minimum_order_quantity); ?>'
                                        data-variant-id='<?php echo e($items->product_variant_id); ?>'
                                        data-product-type="<?php echo e($items->cart_product_type); ?>">

                                    <button wire:ignore class="qtyBtn plus" href="#;">
                                        <ion-icon name="add-outline"></ion-icon>
                                    </button>
                                </div>

                                <a wire:click="remove_from_cart(<?php echo e($items->product_variant_id); ?>, '<?php echo e($items->cart_product_type); ?>')"
                                    class="remove_from_cart remove pointer"
                                    data-variant-id="<?php echo e($items->product_variant_id); ?>"
                                    data-product-type="<?php echo e($items->cart_product_type); ?>">
                                    <ion-icon wire:ignore class="icon" data-bs-toggle="tooltip"
                                        data-bs-placement="top" name="close-outline"></ion-icon>
                                </a>
                            </div>

                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </ul>
            </div>
            <div class="minicart-bottom">
                <div class="subtotal clearfix my-3">
                    <div class="totalInfo clearfix"><span><?php echo e(labels('front_messages.total', 'Total')); ?>:</span><span
                            class="item product-price">
                          
                        <?php echo e(app(CurrencyService::class)->formateCurrency(number_format($cart_data['sub_total'], 2))); ?></span>
                    </div>

                </div>
                <div class="agree-check customCheckbox">
                    <input id="prTearm" name="tearm" type="checkbox" value="tearm" required x-model="agreed" />
                    <label for="prTearm"><?php echo e(labels('front_messages.i_agree_with_the', 'I agree with the')); ?>

                    </label><a wire:navigate href="<?php echo e(url('term-and-conditions')); ?>"
                        class="ms-1 text-link"><?php echo e(labels('front_messages.terms_and_conditions', 'Terms & conditions')); ?></a>
                </div>
                <div class="minicart-action d-flex mt-3">
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(auth()->guard()->check()): ?>
                        <a id="checkoutBtn" href="<?php echo e(url('cart/checkout')); ?>" wire:navigate
                            :class="{ 'disabled': !agreed }"
                            class="cart-checkout proceed-to-checkout btn btn-primary w-50 me-1 disabled"><?php echo e(labels('front_messages.check_out', 'Check Out')); ?></a>
                    <?php else: ?>
                        <?php
                            $store_slug = session('store_slug') ?? '';
                            // Get absolute URL for login (use url() to ensure absolute URL like calculator page)
                            $loginUrl = url('/login');
                            $redirectUrl = urlencode(url('cart/checkout'));

                            // Add query parameters properly
                            $queryParams = [];
                            if ($store_slug) {
                                $queryParams['store'] = $store_slug;
                            }
                            $queryParams['redirect'] = $redirectUrl;

                            $loginUrl .= '?' . http_build_query($queryParams);
                        ?>
                        <a href="<?php echo e($loginUrl); ?>" id="checkoutBtn"
                            onclick="window.location.href='<?php echo e($loginUrl); ?>'; return false;"
                            data-navigate="false"
                            :class="{ 'disabled': !agreed }"
                            class="cart-checkout proceed-to-checkout btn btn-primary w-50 me-1 checkout-login-redirect disabled"><?php echo e(labels('front_messages.check_out', 'Check Out')); ?></a>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                    <a id="viewCartBtn" href="<?php echo e(url('cart')); ?>" wire:navigate
                        :class="{ 'disabled': !agreed }"
                        class="cart-checkout cart-btn btn btn-secondary w-50 ms-1 disabled"><?php echo e(labels('front_messages.view_cart', 'View Cart')); ?></a>
                </div>
            </div>
        </div>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

    <!-- <script>
        // Keep modal qty inputs in sync with localStorage after DOM updates (guest users)
        document.addEventListener('DOMContentLoaded', function () {
            if (typeof syncLocalCartToUI === 'function') {
                syncLocalCartToUI();
            }
        });
        if (typeof Livewire !== 'undefined') {
            Livewire.hook('morph.updated', () => {
                if (typeof syncLocalCartToUI === 'function') {
                    syncLocalCartToUI();
                }
            });
        }

        // Additional handler as backup - runs immediately on click
        document.addEventListener('DOMContentLoaded', function() {
            const checkoutLinks = document.querySelectorAll('.checkout-login-redirect');
            checkoutLinks.forEach(function(link) {
                link.addEventListener('click', function(e) {
                    e.preventDefault();
                    e.stopImmediatePropagation();
                    e.stopPropagation();
                    const href = this.getAttribute('href');
                    if (href) {
                        window.location.href = href;
                    }
                    return false;
                }, true); // Use capture phasea
            });
        });

        // Also handle dynamically added elements
        if (typeof Livewire !== 'undefined') {
            Livewire.hook('morph.updated', ({ el, component }) => {
                const checkoutLinks = el.querySelectorAll ? el.querySelectorAll('.checkout-login-redirect') : [];
                checkoutLinks.forEach(function(link) {
                    link.addEventListener('click', function(e) {
                        e.preventDefault();
                        e.stopImmediatePropagation();
                        e.stopPropagation();
                        const href = this.getAttribute('href');
                        if (href) {
                            window.location.href = href;
                        }
                        return false;
                    }, true);
                });
            });
        }
    </script>
    <script>
document.addEventListener('DOMContentLoaded', function () {
    document.querySelectorAll('.minicart-right-drawer .product-image img').forEach(img => {
        img.style.width = '50px';
        img.style.height = '50px';
        img.style.objectFit = 'cover';
        img.style.display = 'block';
    });
});

if (typeof Livewire !== 'undefined') {
    Livewire.hook('morph.updated', () => {
        document.querySelectorAll('.minicart-right-drawer .product-image img').forEach(img => {
            img.style.width = '50px';
            img.style.height = '50px';
            img.style.objectFit = 'cover';
            img.style.display = 'block';
        });
    });
}
</script> -->


    <!--MiniCart Content-->
</div>
<?php /**PATH /home/solarmar/solarmart-web.neuromonk.co.in/resources/views/components/utility/others/model-cart.blade.php ENDPATH**/ ?>