<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag; ?>
<?php foreach($attributes->onlyProps(['category']) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $attributes = $attributes->exceptProps(['category']); ?>
<?php foreach (array_filter((['category']), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $__defined_vars = get_defined_vars(); ?>
<?php foreach ($attributes as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
} ?>
<?php unset($__defined_vars); ?>

<?php
    use App\Services\StoreService;
    $store_settings = app(StoreService::class)->getStoreSettings();
?>

<div class="category-card text-center">
    <a
        href="<?php echo e(customUrl('categories/' . $category->slug . '/products')); ?>"
        class="category-link block no-underline"
        data-link="<?php echo e(customUrl('categories/' . $category->slug . '/products')); ?>"
        style="display: inline-block; text-decoration: none;">

        <div class="category-image <?php echo e($store_settings['category_card_style'] == 'category_card_style_1' ? 'img-box-rectangle-h150' : 'img-box-h140'); ?> <?php echo e($store_settings['category_card_style'] == 'category_card_style_3' ? 'rounded-circle' : ''); ?>">
            <img class="w-full h-full object-cover rounded-xl"
                src="<?php echo e($category->image); ?>"
                alt="<?php echo e($category->name); ?>">
        </div>

        <div class="mt-2">
            <h4 class="category-title text-base font-semibold capitalize mb-0"><?php echo e($category->name); ?></h4>
        </div>
    </a>
</div>
<?php /**PATH /home/solarmar/solarmart-web.neuromonk.co.in/resources/views/components/utility/categories/cards/cardThree.blade.php ENDPATH**/ ?>