<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag; ?>
<?php foreach($attributes->onlyProps([
    'regular_wishlist' => [],
    'combo_wishlist' => [],
    'favorites_count' => 0,
    'links' => null,
]) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $attributes = $attributes->exceptProps([
    'regular_wishlist' => [],
    'combo_wishlist' => [],
    'favorites_count' => 0,
    'links' => null,
]); ?>
<?php foreach (array_filter(([
    'regular_wishlist' => [],
    'combo_wishlist' => [],
    'favorites_count' => 0,
    'links' => null,
]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $__defined_vars = get_defined_vars(); ?>
<?php foreach ($attributes as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
} ?>
<?php unset($__defined_vars); ?>
<?php
    use App\Models\Product;
    use App\Models\ComboProduct;
    use App\Services\TranslationService;
    use App\Services\MediaService;
    use App\Services\CurrencyService;
    $language_code = app(TranslationService::class)->getLanguageCode();
?>

<div class="col-12 col-sm-12 col-md-12 col-lg-9">
    <div class="dashboard-content h-100">
        <div class="h-100" id="wishlist">
            <div class="orders-card mt-0 h-100">
                <div class="top-sec d-flex-justify-center justify-content-between mb-4">
                    <h2 class="mb-0"><?php echo e(labels('front_messages.my_wishlist', 'My Wishlist ')); ?></h2>
                </div>

                <div class="table-bottom-brd table-responsive">
                    <div class="tabs-listing section p-0">
                        <ul class="product-tabs style2 list-unstyled d-flex-wrap d-none d-md-flex" wire:ignore>
                            <li rel="regular-wishlist" class="active"><a
                                    class="tablink"><?php echo e(labels('front_messages.regular_products', 'Regular Products')); ?></a>
                            </li>
                            <li rel="combo-wishlist"><a
                                    class="tablink"><?php echo e(labels('front_messages.combo_products', 'Combo Products')); ?></a>
                            </li>
                        </ul>

                        <div class="tab-container">
                            <h3 class="tabs-ac-style rounded-5 d-md-none active" rel="regular-wishlist">
                                <?php echo e(labels('front_messages.regular_products', 'Regular Products')); ?></h3>
                            <div id="regular-wishlist" class="tab-content" wire:ignore.self>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(count($regular_wishlist) >= 1): ?>
                                    <table class="table align-middle text-center order-table">
                                        <thead>
                                            <tr class="table-head text-nowrap">
                                                <th scope="col"></th>
                                                <th scope="col">
                                                    <?php echo e(labels('front_messages.image', 'Image')); ?>

                                                </th>
                                                <th scope="col">
                                                    <?php echo e(labels('front_messages.product_details', 'Product Details')); ?>

                                                </th>
                                                <th scope="col">
                                                    <?php echo e(labels('front_messages.price', 'Price')); ?>

                                                </th>
                                                <th scope="col">
                                                    <?php echo e(labels('front_messages.rating', 'Rating')); ?>

                                                </th>
                                                <th scope="col">
                                                    <?php echo e(labels('front_messages.action', 'Action')); ?>

                                                </th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $regular_wishlist; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $details): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php
                                                    $pro_image = app(MediaService::class)->dynamic_image($details['image'], 50);
                                                    $pro_name = app(TranslationService::class)->getDynamicTranslation(
                                                        Product::class,
                                                        'name',
                                                        $details['id'],
                                                        $language_code,
                                                    );
                                                ?>
                                                <tr>
                                                    <td>
                                                        <button class="btn-close remove-favorite"
                                                            data-product-id="<?php echo e($details['id']); ?>"></button>
                                                    </td>
                                                    <td style="height: 100px; width: 100px">
                                                        <img class="blur-up lazyload" data-src="<?php echo e($pro_image); ?>"
                                                            src="<?php echo e($pro_image); ?>" alt="<?php echo e($pro_name); ?>"
                                                            title="<?php echo e($pro_name); ?>" />
                                                    </td>
                                                    <td><span class="name"><?php echo e($pro_name); ?></span>
                                                    </td>
                                                    <td>
                                                        <?php
                                                            if ($details['type'] !== 'variable_product') {
                                                                $price = app(CurrencyService::class)->currentCurrencyPrice(
                                                                    $details['variants'][0]['price'],
                                                                    true,
                                                                );
                                                                $special_price =
                                                                    isset($details['variants'][0]['special_price']) &&
                                                                    $details['variants'][0]['special_price'] > 0
                                                                        ? app(CurrencyService::class)->currentCurrencyPrice(
                                                                            $details['variants'][0]['special_price'],
                                                                            true,
                                                                        )
                                                                        : $price;
                                                            } else {
                                                                $max_price = app(CurrencyService::class)->currentCurrencyPrice(
                                                                    $details['min_max_price']['max_price'],
                                                                    true,
                                                                );
                                                                $special_min_price =
                                                                    isset(
                                                                        $details['min_max_price']['special_min_price'],
                                                                    ) &&
                                                                    $details['min_max_price']['special_min_price'] > 0
                                                                        ? app(CurrencyService::class)->currentCurrencyPrice(
                                                                            $details['min_max_price'][
                                                                                'special_min_price'
                                                                            ],
                                                                            true,
                                                                        )
                                                                        : $max_price;
                                                            }
                                                        ?>

                                                        <span class="price fw-500">
                                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($details['type'] !== 'variable_product'): ?>
                                                                <?php echo e($special_price); ?>

                                                            <?php else: ?>
                                                                <?php echo e($max_price); ?> -
                                                                <?php echo e($special_min_price); ?>

                                                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                        </span>
                                                    </td>

                                                    
                                                    <td><span class="id">★<?php echo e($details['rating']); ?></span>
                                                    </td>

                                                        

                                                      <td>
                                                        <?php
                                                        $inCart  = !empty($details['is_in_cart']);
                                                        $cartQty = $details['cart_qty']
                                                            ?? $details['qty']
                                                            ?? $details['minimum_order_quantity'];
                                                        ?>
                                                         <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($details['type'] == 'variable_product'): ?>
                                                            <a href="#quickview-modal" data-bs-toggle="modal"
                                                                data-bs-target="#quickview_modal"
                                                                class="btn btn-md text-nowrap add_cart  quickview quick-view-modal"
                                                                data-product-id="<?php echo e($details['id']); ?>"
                                                                data-product-variant-id=''><?php echo e(labels('front_messages.add_to_cart', 'Add to Cart')); ?></a>
                                                        <?php else: ?>

                                                        <div class="button-action mt-2  p-2 button-style align-items-center">

                                                            
                                                            <div class="addtocart-btn add_cart <?php echo e($inCart ? 'd-none' : ''); ?>"
                                                                data-product-id="<?php echo e($details['id']); ?>"
                                                                data-product-variant-id="<?php echo e($details['id']); ?>"
                                                                data-name="<?php echo e($pro_name); ?>"
                                                                data-slug="<?php echo e($details['slug']); ?>"
                                                                data-image="<?php echo e(app(MediaService::class)->dynamic_image($details['image'], 220)); ?>"
                                                                data-product-type="regular"
                                                                data-step="<?php echo e($details['quantity_step_size']); ?>"
                                                                data-max="<?php echo e($details['total_allowed_quantity']); ?>"
                                                                data-min="<?php echo e($details['minimum_order_quantity']); ?>"
                                                                data-stock-type="<?php echo e($details['stock_type'] ?? ''); ?>"
                                                                data-store-id="<?php echo e($details['store_id'] ?? ''); ?>"
                                                                data-variant-price="<?php echo e(app(CurrencyService::class)->currentCurrencyPrice(isset($details['variants'][0]['special_price']) && $details['variants'][0]['special_price'] > 0 ? $details['variants'][0]['special_price'] : $details['variants'][0]['price'])); ?>"
                                                            >
                                                                <a class="btn btn-md">
                                                                    <i class="anm anm-bag-l hdr-icon me-2"></i>
                                                                    Add to Cart
                                                                </a>
                                                            </div>

                                                            
                                                            <div class="qtyDetail text-end cart-qtyDetail <?php echo e($inCart ? '' : 'd-none'); ?>">
                                                                <div class="qtyField">
                                                                    <button wire:ignore class="qtyBtn minus">
                                                                        <ion-icon name="remove-outline"></ion-icon>
                                                                    </button>

                                                                    <input type="number"
                                                                        name="quantity"
                                                                        style="width: 100% !important;"
                                                                        class="product-form-input qty"
                                                                        value="<?php echo e($cartQty); ?>"
                                                                        max="<?php echo e($details['total_allowed_quantity'] == 0 ? 'Infinity' : $details['total_allowed_quantity']); ?>"
                                                                        step="<?php echo e($details['quantity_step_size']); ?>"
                                                                        min="<?php echo e($details['minimum_order_quantity']); ?>"
                                                                        data-variant-id="<?php echo e($details['id']); ?>"
                                                                        data-product-type="regular"
                                                                        data-variant-price="<?php echo e(app(CurrencyService::class)->currentCurrencyPrice(isset($details['variants'][0]['special_price']) && $details['variants'][0]['special_price'] > 0 ? $details['variants'][0]['special_price'] : $details['variants'][0]['price'])); ?>"
                                                                    />

                                                                    <button wire:ignore class="qtyBtn plus">
                                                                        <ion-icon name="add-outline"></ion-icon>
                                                                    </button>
                                                                </div>
                                                            </div>

                                                        </div>
                                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        </tbody>
                                    </table>
                                <?php else: ?>
                                    <div class="d-flex flex-column justify-content-center align-items-center py-5">
                                        <div class="opacity-50"><ion-icon name="bookmark-outline"
                                                class="address-location-icon text-muted"></ion-icon></div>
                                        <div class="fs-6 fw-500">
                                            <?php echo e(labels('front_messages.wishlist_is_empty', 'Your Wishlist Appears to be Empty.')); ?>

                                        </div>
                                    </div>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>
                            <h3 class="tabs-ac-style d-md-none" rel="combo-wishlist">
                                <?php echo e(labels('front_messages.combo_products', 'Combo Products')); ?></h3>
                            <div id="combo-wishlist" class="tab-content" wire:ignore.self>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(count($combo_wishlist) >= 1): ?>
                                    <table class="table align-middle text-center order-table">
                                        <thead>
                                            <tr class="table-head text-nowrap">
                                                <th scope="col"></th>
                                                <th scope="col">
                                                    <?php echo e(labels('front_messages.image', 'Image')); ?>

                                                </th>
                                                <th scope="col">
                                                    <?php echo e(labels('front_messages.product_details', 'Product Details')); ?>

                                                </th>
                                                <th scope="col">
                                                    <?php echo e(labels('front_messages.price', 'Price')); ?>

                                                </th>
                                                <th scope="col">
                                                    <?php echo e(labels('front_messages.rating', 'Rating')); ?>

                                                </th>
                                                <th scope="col">
                                                    <?php echo e(labels('front_messages.action', 'Action')); ?>

                                                </th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $combo_wishlist; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $details): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php
                                                    $pro_image = app(MediaService::class)->dynamic_image($details['image'], 50);
                                                    $combo_pro_name = app(TranslationService::class)->getDynamicTranslation(
                                                        ComboProduct::class,
                                                        'title',
                                                        $details['id'],
                                                        $language_code,
                                                    );
                                                ?>
                                                <tr>
                                                    <td>
                                                        <button class="btn-close remove-favorite"
                                                            data-product-id="<?php echo e($details['id']); ?>"
                                                            data-product-type="combo"></button>
                                                    </td>
                                                    <td>
                                                        <img style="height: 100px; width: 100px" class="blur-up lazyload" data-src="<?php echo e($pro_image); ?>"
                                                            src="<?php echo e($pro_image); ?>" alt="<?php echo e($combo_pro_name); ?>"
                                                            title="<?php echo e($combo_pro_name); ?>" />
                                                    </td>

                                                    <td><span class="name"><?php echo e($combo_pro_name); ?></span>
                                                    </td>
                                                    <td>
                                                        <?php
                                                            $price = app(CurrencyService::class)->currentCurrencyPrice($details['price'], true);
                                                            $special_price =
                                                                isset($details['special_price']) &&
                                                                $details['special_price'] > 0
                                                                    ? app(CurrencyService::class)->currentCurrencyPrice(
                                                                        $details['special_price'],
                                                                        true,
                                                                    )
                                                                    : $price;
                                                        ?>

                                                        <span class="price fw-500"><?php echo e($special_price); ?></span>
                                                    </td>

                                                    <td><span class="id">★<?php echo e($details['rating']); ?></span>
                                                    </td>

                                                    <!-- <td>

                                                        <a class="btn btn-md text-nowrap add_cart"
                                                            data-product-id="<?php echo e($details['id']); ?>"
                                                            data-product-variant-id="<?php echo e($details['id']); ?>"
                                                            data-name='<?php echo e($combo_pro_name); ?>'
                                                            data-slug='<?php echo e($details['slug']); ?>' data-brand-name=''
                                                            data-image='<?php echo e($details['image']); ?>'
                                                            data-product-type='combo'
                                                            data-max='<?php echo e($details['total_allowed_quantity']); ?>'
                                                            data-step='<?php echo e($details['quantity_step_size']); ?>'
                                                            data-min='<?php echo e($details['minimum_order_quantity']); ?>'
                                                            data-stock-type=''><?php echo e(labels('front_messages.add_to_cart', 'Add to Cart')); ?></a>

                                                    </td> -->

                                                    <td>
                                                        <?php
                                                        $inCart  = !empty($details['is_in_cart']);
                                                        $cartQty = $details['cart_qty']
                                                            ?? $details['qty']
                                                            ?? $details['minimum_order_quantity'];
                                                        ?>

                                                        <div class="button-action mt-2  p-2 button-style align-items-center">

                                                            
                                                            <div class="addtocart-btn add_cart <?php echo e($inCart ? 'd-none' : ''); ?>"
                                                                data-product-id="<?php echo e($details['id']); ?>"
                                                                data-product-variant-id="<?php echo e($details['id']); ?>"
                                                                data-name="<?php echo e($details['name'] ?? ($details['title'] ?? $combo_pro_name)); ?>"
                                                                data-slug="<?php echo e($details['slug']); ?>"
                                                                data-image="<?php echo e(app(MediaService::class)->dynamic_image($details['image'], 220)); ?>"
                                                                data-product-type="combo"
                                                                data-step="<?php echo e($details['quantity_step_size']); ?>"
                                                                data-max="<?php echo e($details['total_allowed_quantity']); ?>"
                                                                data-min="<?php echo e($details['minimum_order_quantity']); ?>"
                                                                data-stock-type=""
                                                                data-store-id="<?php echo e($details['store_id'] ?? ''); ?>"
                                                                data-variant-price="<?php echo e(app(CurrencyService::class)->currentCurrencyPrice($details['special_price'])); ?>"
                                                            >
                                                                <a class="btn btn-md p-2 button-style d-flex align-items-center">
                                                                    <i class="anm anm-bag-l hdr-icon me-2"></i>
                                                                    Add to Cart
                                                                </a>
                                                            </div>

                                                            
                                                            <div class="qtyDetail text-end cart-qtyDetail <?php echo e($inCart ? '' : 'd-none'); ?>">
                                                                <div class="qtyField" >
                                                                    <button wire:ignore class="qtyBtn minus">
                                                                        <ion-icon name="remove-outline"></ion-icon>
                                                                    </button>

                                                                    <input type="number"
                                                                        name="quantity"
                                                                        style="width: 100% !important;"
                                                                        class="product-form-input qty"
                                                                        value="<?php echo e($cartQty); ?>"
                                                                        max="<?php echo e($details['total_allowed_quantity'] == 0 ? 'Infinity' : $details['total_allowed_quantity']); ?>"
                                                                        step="<?php echo e($details['quantity_step_size']); ?>"
                                                                        min="<?php echo e($details['minimum_order_quantity']); ?>"
                                                                        data-variant-id="<?php echo e($details['id']); ?>"
                                                                        data-variant-price="<?php echo e(app(CurrencyService::class)->currentCurrencyPrice($details['special_price'])); ?>"
                                                                        data-product-type="combo"
                                                                    />

                                                                    <button wire:ignore class="qtyBtn plus">
                                                                        <ion-icon name="add-outline"></ion-icon>
                                                                    </button>
                                                                </div>
                                                            </div>

                                                        </div>

                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        </tbody>
                                    </table>
                                <?php else: ?>
                                    <div class="d-flex flex-column justify-content-center align-items-center py-5">
                                        <div class="opacity-50"><ion-icon name="bookmark-outline"
                                                class="address-location-icon text-muted"></ion-icon></div>
                                        <div class="fs-6 fw-500">
                                            <?php echo e(labels('front_messages.wishlist_is_empty', 'Your Wishlist Appears to be Empty.')); ?>

                                        </div>
                                    </div>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div><?php echo $links; ?></div>
</div>
<?php /**PATH /home/solarmar/solarmart-web.neuromonk.co.in/resources/views/components/utility/wishlist/cards/listCardOne.blade.php ENDPATH**/ ?>