<?php
    $bread_crumb['page_main_bread_crumb'] = labels('front_messages.orders', 'Orders');
    use App\Models\Currency;
    use App\Models\Product;
    use App\Models\ComboProduct;
    use App\Services\TranslationService;
    use App\Services\MediaService;
    use App\Services\CurrencyService;
?>

<div id="page-content">
    <style>
        .order-status-scroll {
            overflow-x: auto;
            white-space: nowrap;
            flex-wrap: nowrap;
            -webkit-overflow-scrolling: touch; /* smooth scroll on iOS */
        }

        /* Optional: hide scrollbar */
        .order-status-scroll::-webkit-scrollbar {
            display: none;
        }
        .order-status-scroll {
            -ms-overflow-style: none;  /* IE and Edge */
            scrollbar-width: none;     /* Firefox */
        }
    </style>
    <?php if (isset($component)) { $__componentOriginal96cd686271162b4db69f9d7c5d07d8a3 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal96cd686271162b4db69f9d7c5d07d8a3 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.utility.breadcrumbs.breadcrumbTwo','data' => ['breadCrumb' => $bread_crumb]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('utility.breadcrumbs.breadcrumbTwo'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['bread_crumb' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($bread_crumb)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal96cd686271162b4db69f9d7c5d07d8a3)): ?>
<?php $attributes = $__attributesOriginal96cd686271162b4db69f9d7c5d07d8a3; ?>
<?php unset($__attributesOriginal96cd686271162b4db69f9d7c5d07d8a3); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal96cd686271162b4db69f9d7c5d07d8a3)): ?>
<?php $component = $__componentOriginal96cd686271162b4db69f9d7c5d07d8a3; ?>
<?php unset($__componentOriginal96cd686271162b4db69f9d7c5d07d8a3); ?>
<?php endif; ?>
    <div class="container-fluid">
        <div class="row">
            <?php if (isset($component)) { $__componentOriginalc6eeb6556c0de45b266b7e26ce9e392e = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalc6eeb6556c0de45b266b7e26ce9e392e = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.utility.my_account_slider.account_slider','data' => ['userInfo' => $user_info]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('utility.my_account_slider.account_slider'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['user_info' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($user_info)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalc6eeb6556c0de45b266b7e26ce9e392e)): ?>
<?php $attributes = $__attributesOriginalc6eeb6556c0de45b266b7e26ce9e392e; ?>
<?php unset($__attributesOriginalc6eeb6556c0de45b266b7e26ce9e392e); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc6eeb6556c0de45b266b7e26ce9e392e)): ?>
<?php $component = $__componentOriginalc6eeb6556c0de45b266b7e26ce9e392e; ?>
<?php unset($__componentOriginalc6eeb6556c0de45b266b7e26ce9e392e); ?>
<?php endif; ?>
            <div class="col-12 col-sm-12 col-md-12 col-lg-9">
                <div class="dashboard-content h-100">
                    <div class="h-100" id="orders">
                        <div class="orders-card mt-0 h-100">
                            <div class="top-sec d-flex-justify-center justify-content-between mb-4">
                                <h2 class="mb-0"><?php echo e(labels('front_messages.my_orders', 'My Orders')); ?></h2>
                            </div>
                            
                            <div class="order-status-scroll d-flex gap-3 mb-3">
                                <button type="button" wire:click="filterOrders('')" wire:loading.attr="disabled"
                                    class="badge rounded-pill bg-info custom-badge <?php echo e($orderStatus == '' ? 'border-2 border-dark' : ''); ?>">
                                    <?php echo e(labels('front_messages.all', 'All')); ?>

                                </button>

                                <button type="button" wire:click="filterOrders('awaiting')" wire:loading.attr="disabled"
                                    class="badge rounded-pill bg-secondary custom-badge <?php echo e($orderStatus == 'awaiting' ? 'border-2 border-dark' : ''); ?>">
                                    <?php echo e(labels('front_messages.awaiting', 'Awaiting')); ?>

                                </button>

                                <button type="button" wire:click="filterOrders('received')" wire:loading.attr="disabled"
                                    class="badge rounded-pill bg-primary custom-badge <?php echo e($orderStatus == 'received' ? 'border-2 border-dark' : ''); ?>">
                                    <?php echo e(labels('front_messages.received', 'Received')); ?>

                                </button>

                                <button type="button" wire:click="filterOrders('processed')" wire:loading.attr="disabled"
                                    class="badge rounded-pill bg-info custom-badge <?php echo e($orderStatus == 'processed' ? 'border-2 border-dark' : ''); ?>">
                                    <?php echo e(labels('front_messages.processing', 'Processing')); ?>

                                </button>

                                <button type="button" wire:click="filterOrders('shipped')" wire:loading.attr="disabled"
                                    class="badge rounded-pill bg-warning custom-badge <?php echo e($orderStatus == 'shipped' ? 'border-2 border-dark' : ''); ?>">
                                    <?php echo e(labels('front_messages.shipped', 'Shipped')); ?>

                                </button>

                                <button type="button" wire:click="filterOrders('delivered')" wire:loading.attr="disabled"
                                    class="badge rounded-pill bg-success custom-badge <?php echo e($orderStatus == 'delivered' ? 'border-2 border-dark' : ''); ?>">
                                    <?php echo e(labels('front_messages.delivered', 'Delivered')); ?>

                                </button>

                                <button type="button" wire:click="filterOrders('cancelled')" wire:loading.attr="disabled"
                                    class="badge rounded-pill bg-danger custom-badge <?php echo e($orderStatus == 'cancelled' ? 'border-2 border-dark' : ''); ?>">
                                    <?php echo e(labels('front_messages.canceled', 'Canceled')); ?>

                                </button>
                            </div>

                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(count($user_orders['order_data'] ?? []) >= 1): ?>
                                <div class="table-bottom-brd table-responsive" wire:loading.class="opacity-50">

                                    <table class="table align-middle text-center order-table">
                                        <thead>
                                            <tr class="table-head text-nowrap">
                                                <th scope="col"><?php echo e(labels('front_messages.image', 'Image')); ?></th>
                                                <th scope="col"><?php echo e(labels('front_messages.order_id', 'Order Id')); ?>

                                                </th>
                                                <th scope="col">
                                                    <?php echo e(labels('front_messages.product_details', 'Product Details')); ?>

                                                </th>
                                                <th scope="col"><?php echo e(labels('front_messages.price', 'Price')); ?></th>
                                                <th scope="col"><?php echo e(labels('front_messages.status', 'Status')); ?></th>
                                                <th scope="col"><?php echo e(labels('front_messages.view', 'View')); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $user_orders['order_data']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user_order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php
                                                    $user_order = json_decode(json_encode($user_order), true);
                                                    // Use the 'image' field directly — it's already a fully resolved URL
                                                    // set by OrderService. Passing image_sm through dynamic_image()
                                                    // double-processes it and falls back to NO_IMAGE when thumbs are missing.
                                                    $order_image = $user_order['order_items'][0]['image']
                                                        ?? $user_order['order_items'][0]['image_sm']
                                                        ?? asset(config('constants.NO_IMAGE'));
                                                ?>
                                                <tr wire:key="order-<?php echo e($user_order['id']); ?>">
                                                    <td><img class="blur-up lazyload" data-src="<?php echo e($order_image); ?>"
                                                            src="<?php echo e($order_image); ?>" width="50" height="50"
                                                            style="object-fit: cover; border-radius: 4px;"
                                                            alt="product" title="product" /></td>
                                                    <td><span class="id">#<?php echo e($user_order['id']); ?></span>
                                                    </td>
                                                    
                                                    <?php
                                                        $product_name = '';
                                                        $language_code = app(
                                                            TranslationService::class,
                                                        )->getLanguageCode();
                                                        if (
                                                            $user_order['order_items'][0]['order_type'] ==
                                                            'regular_order'
                                                        ) {
                                                            $product_name = app(
                                                                TranslationService::class,
                                                            )->getDynamicTranslation(
                                                                Product::class,
                                                                'name',
                                                                $user_order['order_items'][0]['product_id'],
                                                                $language_code,
                                                            );
                                                        } else {
                                                            $product_name = app(
                                                                TranslationService::class,
                                                            )->getDynamicTranslation(
                                                                ComboProduct::class,
                                                                'title',
                                                                $user_order['order_items'][0]['product_id'],
                                                                $language_code,
                                                            );
                                                        }

                                                    ?>
                                                    <td><span
                                                            class="name"><?php echo e($product_name . (count($user_order['order_items']) > 1 ? ' & ' . count($user_order['order_items']) - 1 . ' more items' : '')); ?></span>
                                                    </td>
                                                    <?php
                                                        $currency_details = app(
                                                            CurrencyService::class,
                                                        )->getCurrencyCodeSettings(
                                                            $user_order['order_payment_currency_code'],
                                                            false,
                                                        );
                                                        $amount =
                                                            isset($currency_details) && !empty($currency_details)
                                                                ? (float) $user_order['final_total'] *
                                                                    number_format(
                                                                        (float) $currency_details[0]['exchange_rate'],
                                                                        2,
                                                                    )
                                                                : '';
                                                    ?>
                                                    <td>
                                                        
                                                        <?php

                                                            $currency_symbol = fetchDetails(
                                                                Currency::class,
                                                                ['code' => $user_order['order_payment_currency_code']],
                                                                'symbol',
                                                            );
                                                            // dd($currency_symbol);
                                                            $currency_symbol =
                                                                isset($currency_symbol) && !empty($currency_symbol)
                                                                    ? $currency_symbol[0]->symbol
                                                                    : '$';
                                                        ?>
                                                        <span
                                                            class="price fw-500"><?php echo e($currency_symbol . $amount); ?></span>

                                                    </td>
                                                    <td><span
                                                            class="badge rounded-pill custom-badge"><?php echo e(str_replace('_', ' ', $user_order['order_items'][0]['active_status'])); ?>

                                                        </span>
                                                    </td>
                                                    <td>
                                                        <a href="<?php echo e(customUrl('orders/' . $user_order['id'])); ?>"
                                                            wire:navigate class="view">
                                                            <ion-icon name="eye-outline"
                                                                class="fs-5 hydrated"></ion-icon>
                                                        </a>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>
                            <?php else: ?>
                                <div class="d-flex flex-column justify-content-center align-items-center py-5">
                                    <div class="opacity-50"><ion-icon name="cart-outline"
                                            class="address-location-icon text-muted"></ion-icon></div>
                                    <div class="fs-6 fw-500">
                                        <?php echo e(labels('front_messages.no_orders_have_been_placed', 'No orders have been placed at this Store.')); ?>

                                    </div>
                                </div>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </div>
                    </div>
                   <div class="d-flex justify-content-between align-items-center">
    
    <div class="text-muted small">
        Showing <?php echo e(($currentPage - 1) * $perPage + 1); ?>

        to <?php echo e(min($currentPage * $perPage, $user_orders['total'])); ?>

        of <?php echo e($user_orders['total']); ?> results
    </div>

    
    <ul class="pagination mb-0">

        
        <li class="page-item <?php echo e($currentPage == 1 ? 'disabled' : ''); ?>" aria-disabled="<?php echo e($currentPage == 1 ? 'true' : 'false'); ?>" aria-label="« Previous">
            <button
                class="page-link"
                wire:click="goToPage(<?php echo e($currentPage - 1); ?>)"
                <?php if($currentPage == 1): ?> disabled <?php endif; ?>
            >
                ‹
            </button>
        </li>

        
        <?php
            $totalPages = ceil($user_orders['total'] / $perPage);
        ?>

        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php for($i = 1; $i <= $totalPages; $i++): ?>
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($i >= $currentPage - 2 && $i <= $currentPage + 2): ?>
                <li class="page-item <?php echo e($i == $currentPage ? 'active' : ''); ?>" aria-current="<?php echo e($i == $currentPage ? 'page' : ''); ?>">
                    <button class="page-link" wire:click="goToPage(<?php echo e($i); ?>)"><?php echo e($i); ?></button>
                </li>
            <?php elseif($i == 1 || $i == $totalPages): ?>
                <li class="page-item">
                    <button class="page-link" wire:click="goToPage(<?php echo e($i); ?>)"><?php echo e($i); ?></button>
                </li>
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($i < $currentPage - 3 || $i > $currentPage + 3): ?>
                    <li class="page-item disabled"><span class="page-link">...</span></li>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        <?php endfor; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

        
        <li class="page-item <?php echo e($currentPage == $totalPages ? 'disabled' : ''); ?>" aria-disabled="<?php echo e($currentPage == $totalPages ? 'true' : 'false'); ?>" aria-label="Next »">
            <button
                class="page-link"
                wire:click="goToPage(<?php echo e($currentPage + 1); ?>)"
                <?php if($currentPage == $totalPages): ?> disabled <?php endif; ?>
            >
                ›
            </button>
        </li>
    </ul>
</div>



                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/solarmar/solarmart-web.neuromonk.co.in/resources/views/livewire/elegant/orders/listing.blade.php ENDPATH**/ ?>