

<?php
    use App\Models\Product;
    use App\Models\ComboProduct;
    use App\Services\TranslationService;
    use App\Services\MediaService;
?>
<div id="page-content">
    
    <div class="template-product">
        <div class="page-header text-center">
            <div class="container-fluid">
                <div class="row align-items-center">
                    <div class="col-12 col-sm-12 col-md-12 col-lg-12">
                        <!--Breadcrumbs-->
                        <div class="breadcrumbs"><a wire:navigate href="<?php echo e(customUrl('/')); ?>"
                                title="Back to the home page"><?php echo e(labels('front_messages.home', 'Home')); ?></a><span
                                class="main-title fw-bold"><ion-icon class="align-text-top icon"
                                    name="chevron-forward-outline"></ion-icon><?php echo $bread_crumb['page_main_bread_crumb'] ?? ''; ?></span>
                            <span class="main-title fw-bold">
                                <?php echo e(labels('front_messages.orders', 'Orders')); ?>

                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="container-fluid h-100">
        <div class="orders-card mt-0 h-100">
            <div class="top-sec d-flex-justify-center justify-content-between mb-4">
                <h2 class="mb-0"><?php echo e(labels('front_messages.orders_details', 'Orders Details')); ?></h2>
                <a href="<?php echo e(route('front_end.orders.generatInvoicePDF', ['id' => $user_orders['order_data'][0]->id, 'user_id' => $user_orders['order_data'][0]->user_id])); ?>"
                    target="_blank" class="btn btn-primary btn-sm instructions_files">
                    <i class='bx bx-download me-1'></i><?php echo e(labels('admin_labels.invoice', 'Invoice')); ?>

                </a>

            </div>
            <div class="row mt-2">
                <div class="col-sm-12">
                    <h3><?php echo e(labels('front_messages.order_id', 'order ID')); ?>: #<?php echo e($user_orders['order_data'][0]->id); ?>

                    </h3>
                    <?php
                        use App\Models\Currency;
                        $currency_code = $user_orders['order_data'][0]->order_payment_currency_code;
                        $currency_details = fetchDetails(Currency::class, [
                            'code' => $currency_code,
                        ]);
                        $currency_symbol =
                            isset($currency_details) && !empty($currency_details) ? $currency_details[0]->symbol : '';
                        // dd($currency_symbol);
                    ?>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $order_transaction; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user_order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $user_order['order_items']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user_order_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            
                            <div class="row mt-3">
                                <div class="col-lg-2 col-md-3 col-sm-4">
                                    <div class="product-img mb-3 mb-sm-0 order-image-box">
                                        <?php
                                            // Use the 'image' field directly — already a fully resolved URL
                                            // set by OrderService. image_sm requires physical thumbs on disk.
                                            $order_image = $user_order_item['image']
                                                ?? $user_order_item['image_sm']
                                                ?? asset(config('constants.NO_IMAGE'));
                                            $language_code = app(TranslationService::class)->getLanguageCode();
                                            $product_name = '';

                                            if ($user_order['order_items'][0]['order_type'] == 'regular_order') {
                                                $product_name = app(TranslationService::class)->getDynamicTranslation(
                                                    Product::class,
                                                    'name',
                                                    $user_order_item['product_id'],
                                                    $language_code,
                                                );
                                            } else {
                                                $product_name = app(TranslationService::class)->getDynamicTranslation(
                                                    ComboProduct::class,
                                                    'title',
                                                    $user_order_item['product_id'],
                                                    $language_code,
                                                );
                                            }

                                        ?>
                                        <a wire:navigate
                                            href="<?php echo e(customUrl($user_order['order_items'][0]['order_type'] == 'regular_order' ? 'products/' . $user_order['order_items'][0]['slug'] : 'combo-products/' . $user_order['order_items'][0]['slug'])); ?>"
                                            class="all-product-img product-img rounded-3 slider-link"
                                            data-link="<?php echo e(customUrl($user_order['order_items'][0]['order_type'] == 'regular_order' ? 'products/' . $user_order['order_items'][0]['slug'] : 'combo-products/' . $user_order['order_items'][0]['slug'])); ?>">
                                            <img class="rounded-0 blur-up lazyload" data-src="<?php echo e($order_image); ?>"
                                                src="<?php echo e($order_image); ?>" alt="<?php echo e($product_name); ?>"
                                                title="<?php echo e($product_name); ?>">
                                        </a>

                                    </div>
                                </div>
                                <div class="col-lg-6 col-md-9 col-sm-8">
                                    <div class="tracking-detail d-flex-center">
                                        <ul>
                                            <li>
                                                <div class="left">
                                                    <span><?php echo e(labels('front_messages.product_name', 'Product name')); ?></span>
                                                </div>
                                                <div class="right">
                                                    <a wire:navigate
                                                        href="<?php echo e(customUrl($user_order['order_items'][0]['order_type'] == 'regular_order' ? 'products/' . $user_order['order_items'][0]['slug'] : 'combo-products/' . $user_order['order_items'][0]['slug'])); ?>"
                                                        class="all-product-img product-img rounded-3 slider-link"
                                                        data-link="<?php echo e(customUrl($user_order['order_items'][0]['order_type'] == 'regular_order' ? 'products/' . $user_order['order_items'][0]['slug'] : 'combo-products/' . $user_order['order_items'][0]['slug'])); ?>">
                                                        <span><?php echo e($product_name . ($user_order_item['variant_name'] ? ' - ' . $user_order_item['variant_name'] : '')); ?></span>
                                                    </a>
                                                </div>
                                            </li>
                                            
                                            <li>
                                                <div class="left">
                                                    <span><?php echo e(labels('front_messages.quantity', 'Quantity')); ?></span>
                                                </div>
                                                <div class="right">
                                                    <span><?php echo e($user_order_item['quantity'] ?? '-'); ?></span>
                                                </div>
                                            </li>
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($user_order_item['is_cancelable'] == 1): ?>
                                                <li>
                                                    <div class="left">
                                                        <span><?php echo e(labels('front_messages.cancelable_till', 'Cancelable Till')); ?></span>
                                                    </div>
                                                    <div class="right">
                                                        <span><?php echo e($user_order_item['cancelable_till']); ?></span>
                                                    </div>
                                                </li>
                                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                                            <li>
                                                <div class="left">
                                                    <span><?php echo e(labels('front_messages.total_price', 'Total Price')); ?></span>
                                                </div>
                                                <div class="right">
                                                    <span>
                                                        <?php echo e(isset($currency_details) && !empty($currency_details) ? $currency_symbol . number_format((float) $user_order_item['price'] * $currency_details[0]->exchange_rate, 2) : ''); ?>

                                                    </span>
                                                </div>
                                            </li>

                                            <li>
                                                <div class="left">
                                                    <span><?php echo e(labels('front_messages.final_total', 'Final Total')); ?></span>
                                                </div>
                                                <div class="right">
                                                    <b class="text-black">
                                                        <?php echo e(isset($currency_details) && !empty($currency_details) ? $currency_symbol . number_format((float) $user_order_item['sub_total'] * $currency_details[0]->exchange_rate, 2) : ''); ?>

                                                    </b>
                                                </div>
                                            </li>
                                            
                                            <li>
                                                <div class="left">
                                                    <span><?php echo e(labels('front_messages.otp', 'OTP')); ?></span>
                                                </div>
                                                <div class="right">
                                                    <span><?php echo e($user_order_item['otp'] ?? '-'); ?></span>
                                                </div>
                                            </li>

                                        </ul>
                                    </div>

                                    <?php
                                        $status = [
                                            'awaiting',
                                            'received',
                                            'processed',
                                            'shipped',
                                            'delivered',
                                            'cancelled',
                                            'return_request_pending',
                                            'return_request_decline',
                                            'returned',
                                        ];
                                        $cancelable_till = $user_order_item['cancelable_till'];
                                        $active_status = $user_order_item['active_status'];
                                        $cancellable_index = array_search($cancelable_till, $status);
                                        $active_index = array_search($active_status, $status);
                                    ?>
                                    <?php
                                        $max_days_to_return_item = $system_settings['max_days_to_return_item'] ?? 0;

                                        $deliveredTime = '';
                                        $is_return_time_is_over = false;

                                        if ($user_order_item['active_status'] == 'delivered') {
                                            // foreach ($user_order_item['status'] as $status) {

                                            //}
                                            if (
                                                (isset($user_order_item['status'][3][0]) &&
                                                    $user_order_item['status'][3][0] == 'delivered') ||
                                                (isset($user_order_item['status'][4][0]) &&
                                                    $user_order_item['status'][4][0] == 'delivered')
                                            ) {
                                                $deliveredTime = isset($user_order_item['status'][3][1])
                                                    ? $user_order_item['status'][3][1]
                                                    : $user_order_item['status'][4][1] ?? null;
                                            }

                                            // dd($user_order_item['status'][3][0] == 'delivered');
                                            $deliveredDateTime = DateTime::createFromFormat(
                                                'd-m-Y h:i:sa',
                                                $deliveredTime,
                                            );
                                            // dd($deliveredDateTime);
                                            $returnDeadline = $deliveredDateTime->modify(
                                                '+' . $max_days_to_return_item . ' days',
                                            );
                                            $currentDateTime = new DateTime();
                                            if ($currentDateTime < $returnDeadline) {
                                                $is_return_time_is_over = true;
                                            }
                                        }
                                    ?>
                                    <div class="d-flex">
                                        
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(
                                            $user_order_item['is_already_cancelled'] == 0 &&
                                                $user_order_item['is_cancelable'] == 1 &&
                                                $cancellable_index >= $active_index): ?>
                                            <button class="btn btn-primary btn-sm update_order_item_status"
                                                data-status="cancelled"
                                                data-item-id="<?php echo e($user_order_item['id']); ?>"><?php echo e(labels('front_messages.cancle', 'Cancle')); ?></button>
                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(
                                            $user_order_item['is_returnable'] == 1 &&
                                                $user_order_item['return_request_submitted'] != 1 &&
                                                $user_order_item['active_status'] == 'delivered' &&
                                                $is_return_time_is_over == true): ?>
                                            <button class="btn btn-primary btn-sm update_order_item_status"
                                                data-status="returned"
                                                data-item-id="<?php echo e($user_order_item['id']); ?>"><?php echo e(labels('front_messages.return', 'Return')); ?></button>
                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <!-- End Status Order -->

                            <!-- start bank transfer file upload -->
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($user_orders['order_data'][0]->payment_method == 'Bank Transfer'): ?>
                                <div class="row">
                                    <form action="<?php echo e(Route('orders.send-bank-receipt')); ?>" id="send_bank_receipt_form"
                                        method="POST" enctype="multipart/form-data">

                                        <input type="hidden" name="order_id"
                                            value="<?php echo e($user_orders['order_data'][0]->id); ?>">
                                        <div class="form-group">
                                            <label for="receipt">
                                                <strong><?php echo e(labels('front_messages.bank_payment_receipt', 'Bank Payment Receipt')); ?></strong>
                                            </label>
                                            <input type="file" class="form-control" name="attachments[]"
                                                id="receipt" multiple />
                                        </div>
                                        <div class="form-group">
                                            <button type="reset" class="btn btn-outline-warning btn-xs">
                                                <?php echo e(labels('front_messages.reset', 'Reset')); ?>

                                            </button>
                                            <button type="submit" class="btn btn-outline-blue btn-xs" id="submit_btn">
                                                <?php echo e(labels('front_messages.send', 'Send')); ?>

                                            </button>
                                        </div>
                                    </form>
                                </div>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            
                            <div class="row">
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(isset($bank_transfer[0]) && !empty($bank_transfer)): ?>
                                    <div class="align-items-baseline col-md-6 d-flex gap-2 justify:spaceEvenly">
                                        <?php $i = 1; ?>
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $bank_transfer; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row1): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <small>
                                                [<a href="<?php echo e(customUrl('/storage/' . $row1['attachments'])); ?>"
                                                    target="_blank">
                                                    <?php echo e(labels('front_messages.attachment', 'Attachment')); ?>

                                                    <?php echo e($i); ?>

                                                </a>]
                                            </small>
                                            <?php $i++; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                                        <?php $status = $bank_transfer[0]['status']; ?>
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($status == 0): ?>
                                            <label class="badge bg-warning">
                                                <?php echo e(labels('front_messages.pending', 'Pending')); ?>

                                            </label>
                                        <?php elseif($status == 1): ?>
                                            <label class="badge bg-danger">
                                                <?php echo e(labels('front_messages.rejected', 'Rejected')); ?>

                                            </label>
                                        <?php elseif($status == 2): ?>
                                            <label class="badge bg-primary">
                                                <?php echo e(labels('front_messages.accepted', 'Accepted')); ?>

                                            </label>
                                        <?php else: ?>
                                            <label class="badge bg-danger">
                                                <?php echo e(labels('front_messages.invalid_value', 'Invalid Value')); ?>

                                            </label>
                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </div>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>
                            <!-- end start bank transfer file upload -->

                            <!-- Tracking Steps -->
                            <div class="tracking-steps nav mt-5 mb-4 clearfix justify-content-center">
                                
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($user_order_item['active_status'] == 'cancelled'): ?>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $user_order_item['status']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="step <?php echo e($status[0] == 'cancelled' ? 'current' : ''); ?>">
                                            <span><?php echo e($status[0]); ?></span>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                <?php elseif(
                                    $user_order_item['is_already_returned'] == 1 ||
                                        $user_order_item['return_request_submitted'] >= 1 ||
                                        $user_order_item['active_status'] == 'return_request_pending'): ?>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $user_order_item['status']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div
                                            class="step <?php echo e($status[0] == $user_order_item['active_status'] ? 'current' : ''); ?>">
                                            <span><?php echo e(str_replace('_', ' ', $status[0])); ?></span>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                <?php else: ?>
                                    <div
                                        class="step <?php echo e($user_order_item['active_status'] == 'awaiting' ? 'current' : 'hide'); ?>">
                                        <span><?php echo e(labels('front_messages.awaiting', 'awaiting')); ?></span>
                                    </div>
                                    <div
                                        class="step <?php echo e($user_order_item['active_status'] == 'received' ? 'current' : ''); ?>">
                                        <span><?php echo e(labels('front_messages.received', 'received')); ?></span>
                                    </div>
                                    <div
                                        class="step <?php echo e($user_order_item['active_status'] == 'processed' ? 'current' : ''); ?>">
                                        <span><?php echo e(labels('front_messages.processed', 'processed')); ?></span>
                                    </div>
                                    <div
                                        class="step <?php echo e($user_order_item['active_status'] == 'shipped' ? 'current' : ''); ?>">
                                        <span><?php echo e(labels('front_messages.shipped', 'shipped')); ?></span>
                                    </div>
                                    <div
                                        class="step <?php echo e($user_order_item['active_status'] == 'delivered' ? 'current' : ''); ?>">
                                        <span><?php echo e(labels('front_messages.delivered', 'delivered')); ?></span>
                                    </div>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>
                            <!-- End Tracking Steps -->
                            <!-- Order Table -->
                            <div class="table-bottom-brd table-responsive">
                                <table class="table align-middle text-center order-table">
                                    <thead>
                                        <tr>
                                            <th scope="col"><?php echo e(labels('front_messages.status', 'Status')); ?></th>
                                            <th scope="col"><?php echo e(labels('front_messages.time', 'Time')); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $user_order_item['status']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php
                                                $date = \Carbon\Carbon::createFromFormat('d-m-Y h:i:sa', $status[1]);
                                            ?>
                                            <tr>
                                                <td class="text-capitalize"><?php echo e(str_replace('_', ' ', $status[0])); ?>

                                                </td>
                                                <td>
                                                <?php echo e($date->setTimezone('Asia/Kolkata')->format('d M Y h:i A')); ?></td>

                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                                    </tbody>
                                </table>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($user_order['type'] != 'digital_product'): ?>
                        <div class="mb-2">
                            <div class="top-sec d-flex-justify-center justify-content-between mb-4">
                                <h2 class="mb-0"><?php echo e(labels('front_messages.address_details', 'Address Details')); ?>

                                </h2>
                            </div>
                            <div class="tracking-detail d-flex-center align-items-center mt-2">
                                <ul>
                                    <li>
                                        <div class="left"><span> <?php echo e(labels('front_messages.name', 'Name')); ?> </span>
                                        </div>
                                        <div class="right text-black">
                                            <span
                                                class="text-uppercase"><b><?php echo e($user_order['order_recipient_person']); ?></b></span>
                                        </div>
                                    </li>
                                    <li>
                                        <div class="left"><span> <?php echo e(labels('front_messages.address', 'Address')); ?>

                                            </span>
                                        </div>
                                        <div class="right"><span><?php echo e($user_order['address']); ?></span>
                                        </div>
                                    </li>
                                    
                                </ul>
                            </div>
                        </div>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    <div class="my-2">
                        <div class="top-sec d-flex-justify-center justify-content-between mb-4">
                            <h2 class="mb-0"><?php echo e(labels('front_messages.price_details', 'Price Details')); ?></h2>
                        </div>
                        
                        <div class="tracking-detail d-flex-center align-items-center mt-2">
                            <ul>
                                <li>
                                    <div class="left">
                                        <span><?php echo e(labels('front_messages.payment_mode', 'Payment Mode')); ?></span>
                                    </div>
                                    <div class="right">
                                        <span 
                                            class="text-uppercase"><?php echo e(ucwords(str_replace('_', ' ', $user_order['payment_method']))); ?></span>
                                    </div>
                                </li>
                                <li>
                                    <div class="left">
                                        <span><?php echo e(labels('front_messages.total_price', 'total Price')); ?></span>
                                    </div>
                                    <div class="right">
                                        <span><?php echo e(isset($currency_details) && !empty($currency_details) ? $currency_symbol . number_format((float) $user_order['total'] * $currency_details[0]->exchange_rate, 2) : ''); ?></span>
                                    </div>
                                </li>
                                <li class="<?php echo e($user_order['delivery_charge'] == 0 ? 'd-none' : ''); ?>">
                                    <div class="left">
                                        <span><?php echo e(labels('front_messages.delivary_charge', 'Delivary Charge')); ?></span>
                                    </div>
                                    <div class="right">
                                        <span>+<?php echo e(isset($currency_details) && !empty($currency_details) ? $currency_symbol . number_format((float) $user_order['delivery_charge'] * $currency_details[0]->exchange_rate, 2) : ''); ?></span>
                                    </div>
                                </li>
                                <li class="<?php echo e($user_order['promo_discount'] == 0 ? 'd-none' : ''); ?>">
                                    <div class="left">
                                        <span><?php echo e(labels('front_messages.promo_discount', 'Coupon Discount')); ?></span>
                                    </div>
                                    <div class="right">
                                        <span>-<?php echo e(isset($currency_details) && !empty($currency_details) ? $currency_symbol . number_format((float) $user_order['promo_discount'] * $currency_details[0]->exchange_rate, 2) : ''); ?></span>
                                    </div>
                                </li>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($user_order['wallet_balance'] != 0.0): ?>
                                    <li>
                                        <div class="left">
                                            <span><?php echo e(labels('front_messages.wallet_balance_used', 'Wallet Balance Used')); ?></span>
                                        </div>
                                        <div class="right">
                                            <span><?php echo e(isset($currency_details) && !empty($currency_details) ? $currency_symbol . number_format((float) $user_order['wallet_balance'] * $currency_details[0]->exchange_rate, 2) : ''); ?></span>
                                        </div>
                                    </li>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                <li>
                                    <div class="left">
                                        <span><?php echo e(labels('front_messages.final_total', 'Final Total')); ?></span>
                                    </div>
                                    <div class="right text-black">
                                        <b><?php echo e(isset($currency_details) && !empty($currency_details) ? $currency_symbol . number_format((float) $user_order['final_total'] * $currency_details[0]->exchange_rate, 2) : ''); ?></b>
                                    </div>
                                </li>
                                
                            </ul>
                        </div>
                    </div>
                    <!-- End Order Table -->
                    
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!$tracking_data->isEmpty()): ?>
                        <div class="mb-2">
                            <div class="top-sec d-flex-justify-center justify-content-between mb-4">
                                <h2 class="mb-0"><?php echo e(labels('front_messages.tracking_details', 'Tracking Details')); ?>

                                </h2>
                            </div>
                            <div class="tracking-detail d-flex-center align-items-center mt-2">
                                <ul>
                                    <li>
                                        <div class="left"><span>
                                                <?php echo e(labels('front_messages.courier_agency', 'Courier Agency')); ?> </span>
                                        </div>
                                        <div class="right text-black">
                                            <span
                                                class="text-uppercase"><b><?php echo e($tracking_data[0]['courier_agency']); ?></b></span>
                                        </div>
                                    </li>
                                    <li>
                                        <div class="left"><span>
                                                <?php echo e(labels('front_messages.tracking_id', 'Tracking ID')); ?>

                                            </span>
                                        </div>
                                        <div class="right"><span><?php echo e($tracking_data[0]['tracking_id']); ?></span>
                                        </div>
                                    </li>
                                    <li>
                                        <div class="left">
                                            <span><?php echo e(labels('front_messages.url', 'URL')); ?></span>
                                        </div>
                                        <div class="right">
                                            <span>
                                                <a href="<?php echo e($tracking_data[0]['url']); ?>" target="_blank"
                                                    rel="noopener noreferrer">
                                                    <?php echo e($tracking_data[0]['url']); ?>

                                                </a>
                                            </span>
                                        </div>
                                    </li>

                                </ul>
                            </div>
                        </div>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/solarmar/solarmart-web.neuromonk.co.in/resources/views/livewire/elegant/orders/details.blade.php ENDPATH**/ ?>