<?php
    use App\Services\StoreService;
    use App\Services\MediaService;
    use App\Services\CurrencyService;
    use App\Services\TranslationService;
    use App\Models\Brand;
?>
<div id="page-content" wire:ignore>
    
    <div class="template-product">
        <div class="page-header text-center">
            <div class="container-fluid">
                <div class="row align-items-center">
                    <div class="col-12 col-sm-12 col-md-12 col-lg-12">
                        <!--Breadcrumbs-->
                        <div class="breadcrumbs"><a wire:navigate href="<?php echo e(customUrl('/')); ?>"
                                title="Back to the home page"><?php echo e(labels('front_messages.home', 'Home')); ?></a>
                                <span
                                class="main-title fw-bold"><ion-icon class="align-text-top icon"
                                    name="chevron-forward-outline"></ion-icon>
                                    <?php echo $bread_crumb['page_main_bread_crumb'] ?? ''; ?></span>
                                    
                        </div>
                        <!--End Breadcrumbs-->
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="container-fluid">

        <div class="product-single">
            <div class="row">

                <div class="col-lg-6 col-md-6 col-sm-12 col-12 product-layout-img mb-4 mb-md-0" >
                    <div class="product-sticky-style">
                        <h2 class="product-main-title mb-2  d-block d-md-none" ><?php echo e($product_details->name); ?></h2>
                        <div class="product-review d-flex-center mb-2  d-block d-md-none">
                            <input id="input-3-ltr-star-md" name="input-3-ltr-star-md"
                                class="kv-ltr-theme-svg-star rating-loading d-none"
                                value="<?php echo e($product_details->rating); ?>" dir="ltr" data-size="xs"
                                data-show-clear="false" data-show-caption="false" readonly>
                        </div>
                        <div class="product-details-img product-thumb-left-style d-flex justify-content-center">
                            <div class="product-thumb thumb-left">
                                <div id="gallery" class="product-thumb-vertical h-100">
                                    <?php
                                        $main_image = app(MediaService::class)->dynamic_image($product_details->image, 600);
                                        $main_image_zoom = app(MediaService::class)->dynamic_image($product_details->image, 800);
                                    ?>
                                    <a data-image="<?php echo e($main_image); ?>" data-zoom-image="<?php echo e($main_image_zoom); ?>"
                                        class="slick-slide slick-cloned active">
                                        <img class="blur-up lazyload rounded-0" data-src="<?php echo e($main_image); ?>"
                                            src="<?php echo e($main_image); ?>" alt="<?php echo e($product_details->name); ?>" width="625" height="808" />
                                    </a>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $product_details->other_images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $images): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $other_image = app(MediaService::class)->dynamic_image($images, 600);
                                            $other_image_zoom = app(MediaService::class)->dynamic_image($images, 800);
                                        ?>
                                        <a data-image="<?php echo e($other_image); ?>" data-zoom-image="<?php echo e($other_image_zoom); ?>"
                                            class="slick-slide slick-cloned active">
                                            <img class="blur-up lazyload rounded-0" data-src="<?php echo e($other_image); ?>"
                                                src="<?php echo e($other_image); ?>" alt="<?php echo e($product_details->name); ?>" width="625"
                                                height="808" />
                                        </a>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </div>
                            </div>
                            <div class="zoompro-wrap product-zoom-right rounded-0">
                                <div class="zoompro-span"><img id="zoompro" class="zoompro rounded-0"
                                        src="<?php echo e($main_image); ?>" data-zoom-image="<?php echo e($main_image_zoom); ?>"
                                        alt="<?php echo e($product_details->name); ?>" /></div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-6 col-md-6 col-sm-12 col-12 product-layout-info" style="height: 600px; overflow: auto; scrollbar-width: none;        /* Firefox */
                     -ms-overflow-style: none;">
                    <div class="product-single-meta">
                        <h2 class="product-main-title mb-2 d-none d-md-block"><?php echo e($product_details->name); ?></h2>
                        <div class="product-review d-flex-center mb-2 d-none d-md-block">
                            <input id="input-3-ltr-star-md" name="input-3-ltr-star-md"
                                class="kv-ltr-theme-svg-star rating-loading d-none"
                                value="<?php echo e($product_details->rating); ?>" dir="ltr" data-size="xs"
                                data-show-clear="false" data-show-caption="false" readonly>
                        </div>
                        <div class="product-price d-flex-center">
                            <?php
                                $price = app(CurrencyService::class)->currentCurrencyPrice($product_details->price, true);
                                $special_price =
                                    $product_details->special_price && $product_details->special_price > 0
                                        ? app(CurrencyService::class)->currentCurrencyPrice($product_details->special_price, true)
                                        : $price;
                            ?>
                            <span class="price product_price" id="price">
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($special_price !== $price): ?>
                                    <span class="price old-price"><?php echo e($price); ?></span>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                <?php echo e($special_price); ?>

                            </span>
                        </div>

                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($product_details->product_type != 'digital_product'): ?>
                            <hr class="light-hr" />
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($deliverabilitySettings != false): ?>
                                <p class="featureText">
                                    <?php echo e(labels('front_messages.check_product_deliverability', 'Check Product Deliverability')); ?>

                                </p>
                                <div class="row align-items-center">
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($deliverabilitySettings[0]->product_deliverability_type == 'city_wise_deliverability'): ?>
                                        <div class="col-12 col-md-8 col-lg-10 city_list_div">
                                            <div>
                                                <label for="city"
                                                    class="d-none"><?php echo e(labels('front_messages.city', 'City')); ?>

                                                    <span class="required">*</span></label>
                                                <select class="col-md-12 form-control city_list" id="city_list"
                                                    name="city">
                                                </select>
                                            </div>
                                        </div>
                                    <?php else: ?>
                                        <div class="col-12 col-md-8 col-lg-10">
                                            <label for="pincode"
                                                class="d-none"><?php echo e(labels('front_messages.pincode', 'Pincode')); ?> <span
                                                    class="required-f">*</span></label>
                                            <input name="pincode" placeholder="Enter Pincode" value=""
                                                id="pincode" type="text">
                                        </div>
                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    <div class="col-12 col-md-4 col-lg-2 mt-2 mt-md-0">
                                        <button type="submit"
                                            class="btn rounded w-100 check-product-deliverability"><span><?php echo e(labels('front_messages.check', 'Check')); ?></span></button>
                                    </div>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($deliverabilitySettings[0]->product_deliverability_type == 'city_wise_deliverability'): ?>
                                        <p id="city-warning"  class="fw-400 text-danger text-small">
                                            <?php echo e(labels('front_messages.city_not_on_list', 'If your city is not on the list')); ?>

                                            <?php echo e(labels('front_messages.cannot_deliver', 'we cannot deliver the product there')); ?>.
                                        </p>
                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    <p class="featureText deliverability-res"></p>
                                    <input type="hidden" name="product_deliverability_type"
                                        id="product_deliverability_type"
                                        value="<?php echo e($deliverabilitySettings[0]->product_deliverability_type); ?>">
                                    <input type="hidden" name="product_id" id="product_id"
                                        value="<?php echo e($product_id); ?>">
                                    <input type="hidden" name="product_type" id="product_type" value="combo">
                                </div>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        <div class="mb-10px text-muted"><?php echo e($product_details->short_description); ?></div>
                        <div class="col-12 text-muted">
                            <?php echo $product_details->description; ?>

                            <div class="mt-3">
                                <?php echo $product_details->extra_description; ?>

                            </div>
                        </div>

                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!empty($product_details->made_in)): ?>
                         <hr class="light-hr" />
                            <p class="product-sku mb-10px"><?php echo e(labels('front_messages.made_in', 'Made In')); ?>:<span
                                    class="text fw-500"><?php echo e($product_details->made_in); ?></span></p>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!empty($product_details->sku)): ?>
                            <p class="product-sku mb-10px"><?php echo e(labels('front_messages.sku', 'SKU')); ?>:<span
                                    class="text fw-500"><?php echo e($product_details->sku); ?></span></p>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(count($product_details->tags) >= 1): ?>
                            <p class="text-uppercase text-black mb-10px"><ion-icon name="pricetags-outline"
                                    class="custom-icon fs-6 me-1"></ion-icon>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $product_details->tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <a href="<?php echo e(customUrl('combo-products/?tag=' . $tag)); ?>"
                                        class="text fw-500 border border-2 px-1 p-0 tag-filter"
                                        title="<?php echo $tag; ?>"><?php echo $tag; ?>

                                    </a>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </p>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($product_details->stock_type != ''): ?>
                            <div class="product-availability p-0 mb-10px position-static col-lg-9">
                                <div class="lh-1 d-flex justify-content-between">
                                    <div class="text-sold fw-600"><?php echo e(labels('front_messages.currently', 'Currently')); ?>

                                        , <strong class="text-link"></strong>
                                        <?php echo e(labels('front_messages.items_in_stock', 'Items are in stock!')); ?>

                                    </div>
                                </div>
                            </div>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>
                    <hr class="light-hr" />
                    <h4><?php echo e(labels('front_messages.products_included_in_combo', 'Products Included In Combo')); ?></h4>
                    <div class="table-responsive w-100 mt-n2">
                        <table class="grouped-product-list group-table">

                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $product_details->product_details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php 
                                    $item_image = app(MediaService::class)->getImageUrl($item['image'], 'thumb', 'sm');
                                ?>
                                <tr class="grouped-product-list-item border-bottom">
                                    <td class="product-thumb">
                                        <div class="position-relative combo-include-pro-img">
                                            <img class="blur-up lazyload" data-src="<?php echo e($item_image); ?>"
                                                src="<?php echo e($item_image); ?>" alt="<?php echo e($item['name']); ?>"
                                                title="<?php echo e($item['name']); ?>" />
                                        </div>
                                    </td>
                                    <td class="product-label px-3">
                                        <div class="product-name fw-500 mb-2 text-ellipsis"><a wire:navigate
                                                href="<?php echo e(customUrl('products/' . $item['slug'])); ?>"><?php echo e($item['name']); ?></a>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </table>
                    </div>
                    <div class="product-swatches-option">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $product_details->attributes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attributes): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $attribute_ids = explode(',', $attributes['ids']);
                                $attribute_values = explode(',', $attributes['value']);
                            ?>
                            <div class="product-item swatches-size w-100 mb-2 swatch-1 option2" data-option-index="1">
                                <label class="label d-flex align-items-center"><?php echo e($attributes['name']); ?>:</label>
                                <ul class="variants-size size-swatches d-flex-center pt-1 clearfix">
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $attribute_values; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="swatch x-large available p-1 toggleInput"
                                            onclick="toggleInput(this)">
                                            <input type="radio" class="swatchLbl attributes d-none"
                                                data-bs-toggle="tooltip" value="<?php echo e($attribute_ids[$key]); ?>"
                                                data-bs-placement="top" title="<?php echo e($val); ?>"
                                                id="variant-<?php echo e($attribute_ids[$key]); ?>"><?php echo e($val); ?></span>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </ul>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        
                    </div>

                    <div class="product-action d-flex-wrap my-3 my-md-4 button-action">
                            <div class="qtyDetail text-end cart-qtyDetail fl-1 ms-3 <?php echo e(empty($product_details->is_in_cart) ? 'd-none' : ''); ?>">
                            <div class="qtyField">
                                <button class="qtyBtn minus">
                                    <ion-icon name="remove-outline"></ion-icon>
                                </button>

                                <input type="number"
                                        name="quantity"
                                        class="product-form-input qty"
                                        value="<?php echo e(!empty($product_details->is_in_cart) ? ($product_details->cart_qty ?? $product_details->qty ?? $product_details->minimum_order_quantity) : $product_details->minimum_order_quantity); ?>"
                                        max="<?php echo e($product_details->total_allowed_quantity == 0 ? 'Infinity' : $product_details->total_allowed_quantity); ?>"
                                        step="<?php echo e($product_details->quantity_step_size); ?>"
                                        min="<?php echo e($product_details->minimum_order_quantity); ?>"
                                        data-variant-id="<?php echo e($product_details->id); ?>"
                                        data-variant-price="<?php echo e(app(CurrencyService::class)->currentCurrencyPrice($product_details->special_price > 0 ? $product_details->special_price : $product_details->price, false)); ?>"
                                        data-product-type="combo" />

                                <button class="qtyBtn plus">
                                    <ion-icon name="add-outline"></ion-icon>
                                </button>
                            </div>
                        </div>
                        <?php
                            $variant_id = $product_details->id;

                            // ✅ Calculate base price (special or regular)
                            $base_price = $product_details->special_price > 0 ? $product_details->special_price : $product_details->price;

                            // ✅ Convert to current currency (returns number without symbol)
                            $variant_price = app(CurrencyService::class)->currentCurrencyPrice($base_price, false);
                        ?>
                            <div class="product-form-submit add_cart fl-1 ms-3 addtocart-btn <?php echo e(!empty($product_details->is_in_cart) ? 'd-none' : ''); ?>">
                            <button type="submit" name="add"
                                class="btn btn-secondary product-form-cart-submit add_cart addtocart-btn"
                                data-product-reference-id="<?php echo e(isset($reference_id) && !empty($reference_id) ? $reference_id : ''); ?>"
                                id="add_cart" data-product-variant-id="<?php echo e($variant_id); ?>"
                                data-name='<?php echo e($product_details->name); ?>' data-slug='<?php echo e($product_details->slug); ?>'
                                data-brand-name='' data-image='<?php echo e($product_details->image); ?>'
                                data-product-type='combo'
                                data-max='<?php echo e($product_details->total_allowed_quantity); ?>'
                                data-step='<?php echo e($product_details->quantity_step_size); ?>'
                                data-min='<?php echo e($product_details->minimum_order_quantity); ?>'
                                data-stock-type='<?php echo e($product_details->stock_type); ?>'
                                data-store-id='<?php echo e($product_details->store_id); ?>'
                                data-product-variant-id="<?php echo e($variant_id); ?>"
                                data-variant-price="<?php echo e($variant_price); ?>">
                                <span><?php echo e(labels('front_messages.add_to_cart', 'Add to cart')); ?></span>
                            </button>
                        </div>
                        <div class="product-form-submit buyit fl-1 ms-3">
                            <button type="submit" class="btn btn-primary buy_now add_cart dlt-add-cart"
                                data-product-reference-id="<?php echo e(isset($reference_id) && !empty($reference_id) ? $reference_id : ''); ?>"
                                data-product-variant-id="<?php echo e($variant_id); ?>"
                                data-name='<?php echo e($product_details->name); ?>' data-slug='<?php echo e($product_details->slug); ?>'
                                data-brand_name='' data-image='<?php echo e($product_details->image); ?>'
                                data-product-type='combo'
                                data-max='<?php echo e($product_details->total_allowed_quantity); ?>'
                                data-step='<?php echo e($product_details->quantity_step_size); ?>'
                                data-min='<?php echo e($product_details->minimum_order_quantity); ?>'
                                data-store-id='<?php echo e($product_details->store_id); ?>'
                                data-variant-price="<?php echo e($variant_price); ?>">
                                <span><?php echo e(labels('front_messages.buy_it_now', 'Buy Now')); ?></span>
                            </button>
                        </div>
                    </div>
                    
                    <div class="d-flex flex-column flex-md-col flex-lg-row justify-content-between">
                    <p class="infolinks d-flex-center justify-content-start mb-2">
                        <a class="cursor-pointer text-link remove-favorite rem-fav-btn text-danger <?php echo e($product_details->is_favorite == 0 ? 'd-none' : 'd-flex'); ?>"
                            data-product-id="<?php echo e($product_details->id); ?>" data-product-type="combo"><i
                                class="hdr-icon icon anm anm-heart fs-6 me-2"></i><span><?php echo e(labels('front_messages.remove_from_wishlist', 'Remove from Wishlist')); ?></span></a>
                        <a class="cursor-pointer text-link add-favorite <?php echo e($product_details->is_favorite == 0 ? 'd-flex' : 'd-none'); ?>"
                            data-product-id="<?php echo e($product_details->id); ?>" data-product-type="combo"><i
                                class="hdr-icon icon anm anm-heart-l fs-6 me-2"></i><span><?php echo e(labels('front_messages.add_to_wishlist', 'Add to Wishlist')); ?></span></a>
                        <a class="text-link add-compare btn-icon compare add-compare"
                            data-product-id="<?php echo e($product_details->id); ?>"
                            data-product-variant-id="<?php echo e($product_details->id); ?>"
                            data-name="<?php echo e($product_details->name); ?>"
                            data-slug="<?php echo e($product_details->slug); ?>"
                            data-brand-name="<?php echo e(app(TranslationService::class)->getDynamicTranslation(Brand::class, 'name', $product_details->brand, $language_code)); ?>"
                            data-image="<?php echo e(app(MediaService::class)->dynamic_image($product_details->image, 220)); ?>"
                            data-product-type="combo"
                            data-max="<?php echo e($product_details->total_allowed_quantity); ?>"
                            data-step="<?php echo e($product_details->quantity_step_size); ?>"
                            data-min="<?php echo e($product_details->minimum_order_quantity); ?>"
                            data-stock-type="<?php echo e($product_details->stock_type); ?>"
                            data-store-id="<?php echo e($product_details->store_id); ?>"
                            data-variant-price="<?php echo e(app(CurrencyService::class)->currentCurrencyPrice($product_details->special_price > 0 ? $product_details->special_price : $product_details->price)); ?>"
                            data-bs-toggle="tooltip"
                            data-bs-placement="left"
                            title="Add to Compare">
                            <i class="icon anm anm-random-r fs-6 me-2"></i>
                            <span><?php echo e(labels('front_messages.add_to_compare', 'Add to Compare ')); ?></span></a>
                    </p>
                    <div class="social-sharing d-flex-center   lh-lg">
                            <span class="sharing-lbl fw-600"><?php echo e(labels('front_messages.share', 'Share')); ?> :</span>
                            <div class="shareon">
                                <a class="facebook"
                                    data-text="Take a Look at this <?php echo e($product_details->name); ?> on <?php echo e($system_settings['app_name']); ?>"></a>
                                <a class="whatsapp"
                                    data-text="Take a Look at this <?php echo e($product_details->name); ?> on <?php echo e($system_settings['app_name']); ?>"></a>
                                <!-- <a class="youtube"
                                    data-text="Take a Look at this <?php echo e($product_details->name); ?> on <?php echo e($system_settings['app_name']); ?>"></a> -->
                                <a class="linkedin"
                                    data-text="Take a Look at this <?php echo e($product_details->name); ?> on <?php echo e($system_settings['app_name']); ?>"></a>
                                <!-- <a class="copy-url"></a> -->
                            </div>
                    </div>
                    </div>
                    <hr class="light-hr" />
                    <div class="product-info">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($product_details->product_type == 'digital_product'): ?>
                            <div class="freeShipMsg featureText mb-2 d-flex"><ion-icon name="cube-outline"
                                    class="fs-5 me-2"></ion-icon><?php echo e(labels('front_messages.digital_product', 'Digital Product')); ?>

                            </div>
                        <?php else: ?>
                            <div class="freeShipMsg featureText mb-2 d-flex"><ion-icon name="ribbon-outline"
                                    class="fs-5 me-2"></ion-icon>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!empty($product_details->guarantee_period)): ?>
                                    <b class="freeShip me-1"><?php echo e($product_details->guarantee_period); ?></b>
                                <?php else: ?>
                                    <?php echo e(labels('front_messages.no_guarantee', 'No Guarantee')); ?>

                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>
                            <div class="freeShipMsg featureText mb-2 d-flex"><ion-icon name="shield-checkmark-outline"
                                    class="fs-5 me-2"></ion-icon>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!empty($product_details->warranty_period)): ?>
                                    <b class="freeShip me-1"><?php echo e($product_details->warranty_period); ?></b>
                                <?php else: ?>
                                    <?php echo e(labels('front_messages.no_warranty', 'No Warranty')); ?>

                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>
                            <div class="freeShipMsg featureText mb-2 d-flex"><ion-icon name="refresh-outline"
                                    class="fs-5 me-2"></ion-icon><?php echo e($product_details->is_returnable == 1 ? 'Returnable' : 'Non Returnable'); ?>

                            </div>
                            <div class="freeShipMsg featureText mb-2 d-flex"><ion-icon name="pin-outline"
                                    class="fs-5 me-2"></ion-icon>
                                <?php echo e($product_details->cod_allowed == 1 ? 'Cash on Delivery available' : 'Cash on Delivery Not available'); ?>

                            </div>
                            <div class="freeShipMsg featureText mb-2 d-flex"><ion-icon name="shield-checkmark-outline"
                                    class="fs-5 me-2"></ion-icon>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($product_details->is_cancelable == 1): ?>
                                    <b class="freeShip me-1"><?php echo e(labels('front_messages.cancel_till', 'Cancel Till')); ?>

                                        <?php echo e($product_details->cancelable_till); ?></b>
                                <?php else: ?>
                                    <?php echo e(labels('front_messages.non_cancelable', 'Non Cancelable')); ?>

                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($product_details->stock_type != ''): ?>
                                <p class="product-stock d-flex">
                                    <?php echo e(labels('front_messages.availability', 'Availability')); ?>:
                                    <span class="pro-stockLbl ps-0">
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($product_details->availability >= 1): ?>
                                            <span
                                                class="d-flex-center stockLbl instock text-uppercase"><?php echo e(labels('front_messages.in_stock', 'In stock')); ?>:</span>
                                        <?php else: ?>
                                            <span
                                                class="d-flex-center stockLbl outstock text-uppercase text-danger"><?php echo e(labels('front_messages.out_of_stock', 'Out of Stock')); ?>:</span>
                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </span>
                                </p>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        <hr class="light-hr" />
                        <div class="freeShipMsg featureText mb-2 d-flex align-items-center gap-2 fw-600 fs-6"><span
                                class="seller-icon"><ion-icon name="storefront-outline"></ion-icon></span> <a
                                wire:navigate
                                href="<?php echo e(customUrl('sellers/' . $product_details->seller_slug)); ?>"><?php echo e($product_details->seller_name); ?></a>
                        </div>

                        <div class="product-review d-flex-center mb-2 gap-2">
                            <input id="input-3-ltr-star-md" name="input-3-ltr-star-md"
                                class="kv-ltr-theme-svg-star rating-loading d-none"
                                value="<?php echo e($product_details->seller_rating); ?>" dir="ltr" data-size="xs"
                                data-show-clear="false" data-show-caption="false" readonly></span>|<span
                                class="fw-500"><?php echo e($product_details->seller_rating); ?></span>
                        </div>


                    </div>
                </div>
            </div>
        </div>
        
        
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($siblingsProduct['next_product'] != null): ?>
            <a wire:navigate href="<?php echo e(customUrl('combo-products/' . $siblingsProduct['next_product']->slug)); ?>"
                class="product-nav next-pro clr-none d-flex-center justify-content-between border-radius"
                title="Next Product">
                <?php
                    $next_product_img = app(MediaService::class)->dynamic_image($siblingsProduct['next_product']->image, 200);
                ?>
                <span class="img"><img class="rounded-0 rounded-end-0" src="<?php echo e($next_product_img); ?>"
                        alt="<?php echo e($siblingsProduct['next_product']->name); ?>" width="120" height="170" /></span>
                <span class="details">
                    <span class="name fw-600"><?php echo e($siblingsProduct['next_product']->name); ?></span>
                    <span
                        class="price"><?php echo e(app(CurrencyService::class)->currentCurrencyPrice(
                            (float) ($siblingsProduct['next_product']->special_price > 0
                                ? $siblingsProduct['next_product']->special_price
                                : $siblingsProduct['next_product']->price),
                            true,
                        )); ?>

                    </span>
                </span>
            </a>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        
        <div class="tabs-listing section pb-0">
            <ul class="product-tabs list-unstyled d-flex-wrap border-bottom d-none d-md-flex">
                
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($product_details->attributes != []): ?>
                    <li rel="additionalInformation"><a class="tablink"
                            rel="additionalInformation"><?php echo e(labels('front_messages.additional_information', 'Additional Information')); ?></a>
                    </li>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                <li rel="reviews"><a class="tablink"
                        rel="reviews"><?php echo e(labels('front_messages.reviews', 'Reviews')); ?></a></li>
                <li rel="compare_item">
                    <a class="tablink" rel="compare_item">
                        <?php echo e(labels('front_messages.compare_products', 'Compare Products')); ?>

                    </a>
                </li>
            </ul>

            <div class="tab-container">
                <!--Description-->
                
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($product_details->attributes != []): ?>
                    <!--Additional Information-->
                    <h3 class="tabs-ac-style d-md-none" rel="additionalInformation">
                        <?php echo e(labels('front_messages.additional_information', 'Additional Information')); ?>

                    </h3>
                    <div id="additionalInformation" class="tab-content">
                        <div class="product-description">
                            <div class="row">
                                <div class="col-12 col-sm-12 col-md-12 col-lg-12 mb-4 mb-md-0">
                                    <div class="table-responsive">
                                        <table class="table table-bordered align-middle table-part mb-0">
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $product_details->attributes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attributes): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    
                                                    <th><?php echo e($attributes['name']); ?></th>
                                                    <td><?php echo e($attributes['value']); ?></td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                <h3 class="tabs-ac-style d-md-none" rel="reviews"><?php echo e(labels('front_messages.reviews', 'Reviews')); ?>

                </h3>
                <div id="reviews" class="tab-content">
                    <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('pages.customer-ratings', ['productId' => $product_id,'productDetails' => $product_details,'product_id' => $product_id,'product_details' => $product_details]);

$key = null;

$key ??= \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::generateKey('lw-4091997040-0', null);

$__html = app('livewire')->mount($__name, $__params, $key);

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>

                </div>
                <h3 class="tabs-ac-style d-md-none" rel="compare_item">
                    <?php echo e(labels('front_messages.compare_products', 'Compare Products')); ?>

                </h3>
                <div id="compare_item" class="tab-content">
                    <div class="text-center py-5">
                        <ion-icon name="git-compare-outline" style="font-size: 48px; color: #ccc;"></ion-icon>
                        <p class="mt-3 text-muted">Loading compare list...</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(count($relative_products) >= 1): ?>
        <section class="section product-slider pb-0">
            <div class="container-fluid">
                <?php
                    $heading['title'] = labels('front_messages.related_products', 'Related Products');
                    $heading['short_description'] =
                        labels('front_messages.products_related_to', 'Products Related to ') . $product_details->name;
                ?>
                <?php if (isset($component)) { $__componentOriginal4c70107eded5000fb2dc7412a49867ad = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal4c70107eded5000fb2dc7412a49867ad = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.utility.section_header.sectionHeaderTwo','data' => ['heading' => $heading]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('utility.section_header.sectionHeaderTwo'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['heading' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($heading)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal4c70107eded5000fb2dc7412a49867ad)): ?>
<?php $attributes = $__attributesOriginal4c70107eded5000fb2dc7412a49867ad; ?>
<?php unset($__attributesOriginal4c70107eded5000fb2dc7412a49867ad); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal4c70107eded5000fb2dc7412a49867ad)): ?>
<?php $component = $__componentOriginal4c70107eded5000fb2dc7412a49867ad; ?>
<?php unset($__componentOriginal4c70107eded5000fb2dc7412a49867ad); ?>
<?php endif; ?>
                <?php
                    $store_settings = app(StoreService::class)->getStoreSettings();
                ?>
                <!--Product Grid-->
                <div
                    class="swiper style1-mySwiper gp15 arwOut5 hov-arrow grid-products <?php echo e(($store_settings['products_display_style_for_web'] ?? '') == 'products_display_style_for_web_3' ? 'pro-hover3' : ''); ?>">
                    <div class="swiper-wrapper">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $relative_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $details): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="swiper-slide ">
                                <?php
                                    $store_settings = app(StoreService::class)->getStoreSettings();
                                    $component = getProductDisplayComponent($store_settings);
                                ?>

                                <?php if (isset($component)) { $__componentOriginal511d4862ff04963c3c16115c05a86a9d = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal511d4862ff04963c3c16115c05a86a9d = $attributes; } ?>
<?php $component = Illuminate\View\DynamicComponent::resolve(['component' => $component] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('dynamic-component'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\DynamicComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['details' => $details]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal511d4862ff04963c3c16115c05a86a9d)): ?>
<?php $attributes = $__attributesOriginal511d4862ff04963c3c16115c05a86a9d; ?>
<?php unset($__attributesOriginal511d4862ff04963c3c16115c05a86a9d); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal511d4862ff04963c3c16115c05a86a9d)): ?>
<?php $component = $__componentOriginal511d4862ff04963c3c16115c05a86a9d; ?>
<?php unset($__componentOriginal511d4862ff04963c3c16115c05a86a9d); ?>
<?php endif; ?>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>
                    <div class="swiper-button-next"></div>
                    <div class="swiper-button-prev"></div>
                </div>
                <!--End Product Grid-->
            </div>
        </section>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    <!--End Related Products-->
    <div class="pswp" tabindex="-1" role="dialog">
        <div class="pswp__bg"></div>
        <div class="pswp__scroll-wrap">
            <div class="pswp__container">
                <div class="pswp__item"></div>
                <div class="pswp__item"></div>
                <div class="pswp__item"></div>
            </div>
            <div class="pswp__ui pswp__ui--hidden">
                <div class="pswp__top-bar">
                    <div class="pswp__counter"></div>
                    <button class="pswp__button pswp__button--close" title="Close (Esc)"></button>
                    <button class="pswp__button pswp__button--share" title="Share"></button>
                    <button class="pswp__button pswp__button--fs" title="Toggle fullscreen"></button>
                    <button class="pswp__button pswp__button--zoom" title="Zoom in/out"></button>
                    <div class="pswp__preloader">
                        <div class="pswp__preloader__icn">
                            <div class="pswp__preloader__cut">
                                <div class="pswp__preloader__donut"></div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="pswp__share-modal pswp__share-modal--hidden pswp__single-tap">
                    <div class="pswp__share-tooltip"></div>
                </div>
                <button class="pswp__button pswp__button--arrow--left" title="Previous (arrow left)"></button>
                <button class="pswp__button pswp__button--arrow--right" title="Next (arrow right)"></button>
                <div class="pswp__caption">
                    <div class="pswp__caption__center"></div>
                </div>
            </div>
        </div>
    </div>
    <!--Product Video Modal-->
    <div class="productVideo-modal modal fade" id="productVideo_modal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-body p-0">
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    <div class="ratio ratio-16x9 productVideo-wrap">
                        <iframe class="rounded-0" src="https://www.youtube.com/embed/NpEaa2P7qZI"
                            title="YouTube video" allowfullscreen></iframe>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Sticky Cart -->
     
</div>
<script src="<?php echo e(asset('frontend/elegant/js/lightbox.js')); ?>" defer></script>
<script>
    function toggleInput(liElement) {
        var inputElement = liElement.querySelector('input[type="radio"]');
        if (inputElement) {
            inputElement.click();
        }
    }
</script>
<?php /**PATH /home/solarmar/solarmart-web.neuromonk.co.in/resources/views/livewire/elegant/products/combo-details.blade.php ENDPATH**/ ?>