<?php
    use App\Services\MediaService;
?>
<div class="search-product-wrapper position-relative">
    <div class="search-field-container">
        <div class="input-group search-input-group">
            <input type="text" wire:model.live.debounce.300ms="search" wire:keydown.enter="navigateToFirstResult"
                class="form-control search-input" placeholder="Search products..." autocomplete="off" />
            <span class="input-search-icon">
                <div wire:click="navigateToFirstResult" style="cursor: pointer;">
                    <ion-icon wire:ignore wire:loading.remove wire:target="search" name="search-outline"></ion-icon>
                </div>
                <div wire:loading wire:target="search" class="spinner-border spinner-border-sm text-primary"
                    role="status">
                    <span class="visually-hidden">Loading...</span>
                </div>
            </span>
        </div>
    </div>

    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($search !== ""): ?>
        <div class="search-dropdown-container shadow-sm border-0 rounded-4 mt-3 bg-white">
            <ul class="list-unstyled mb-0 py-2">
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(count($search_products) > 0 || count($combo_search_products) > 0): ?>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $search_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="search-result-item">
                            <a wire:navigate href="<?php echo e(customUrl('products?search=' . urlencode(strip_tags($product['name'])))); ?>"
                                class="d-block px-4 py-3 text-decoration-none text-dark">
                                <?php echo $product['name']; ?>

                            </a>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $combo_search_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $combo_product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="search-result-item">
                            <a wire:navigate
                                href="<?php echo e(customUrl('combo-products?search=' . urlencode(strip_tags($combo_product->title)))); ?>"
                                class="d-block px-4 py-3 text-decoration-none text-dark">
                                <?php echo $combo_product->title; ?> <small class="text-muted">(Combo)</small>
                            </a>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                <?php else: ?>
                    <li class="px-4 py-3 text-muted">
                        No products found for "<?php echo e($search); ?>"
                    </li>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </ul>
        </div>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

    <style>
        .search-product-wrapper {
            width: 100%;
        }

        .search-input-group {
            position: relative;
            background: #fff;
            border: 2px solid #e9e4deff;
            /* Orange border as in image */
            border-radius: 30px !important;
            /* Fully rounded */
            padding: 2px 5px;
            overflow: hidden;
        }

        .search-input {
            border: none !important;
            padding: 12px 25px !important;
            font-size: 16px !important;
            background: transparent !important;
        }

        .search-input:focus {
            box-shadow: none !important;
        }

        .input-search-icon {
            position: absolute;
            right: 20px;
            top: 50%;
            transform: translateY(-50%);
            color: #c5beb6ff;
            font-size: 22px;
            display: flex;
            align-items: center;
            pointer-events: auto;
            z-index: 5;
        }

        .search-dropdown-container {
            position: static;
            /* Let it flow naturally in mobile overlay body */
            width: 100%;
            border: 1px solid #e9ecef !important;
        }

        .search-result-item a {
            font-size: 16px;
            border-bottom: 1px solid #f8f9fa;
        }

        .search-result-item:last-child a {
            border-bottom: none;
        }

        .search-result-item a:hover {
            background-color: #fff9f1;
            color: var(--primary-color) !important;
        }

        /* Desktop specific adjustments if needed */
        @media (min-width: 992px) {
            .search-product-wrapper {
                min-width: 300px;
            }

            .search-dropdown-container {
                position: absolute;
                top: 100%;
                left: 0;
                z-index: 1000;
                max-height: 400px;
                overflow-y: auto;
            }
        }
    </style>
</div><?php /**PATH /home/solarmar/solarmart-web.neuromonk.co.in/resources/views/components/header/search-product.blade.php ENDPATH**/ ?>