<!-- Product Quickview Modal-->
<div wire:ignore.self class="quickview-modal modal fade" id="quickview_modal" tabindex="-1" aria-hidden="true">
    <?php
        use App\Models\Category;
        use App\Models\Brand;
        use App\Services\TranslationService;
        use App\Services\MediaService;
        use App\Services\CurrencyService;
    ?>
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">
            <div wire:loading class="my-4 ">
                <div class="d-flex justify-content-center align-items-center ">
                    <div class="spinner-border text-primary" role="status">
                        <span class="visually-hidden">Loading...</span>
                    </div>
                </div>
            </div>
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(count($product) >= 1): ?>
                <div class="modal-body">
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    <?php 
                    $product[0] = (object)$product[0];
                    ?>
                    <div class="row">
                        <div
                            class="col-12 col-sm-6 col-md-6 col-lg-6 mb-3 mb-md-0 d-flex flex-column justify-content-between">
                            <!-- Model Thumbnail -->
                            <div id="quickView" class="carousel slide">
                                <!-- Image Slide carousel items -->
                                <div class="carousel-inner">
                                    <?php
                                        $main_image = app(MediaService::class)->dynamic_image($product[0]->image, 800);
                                    ?>
                                    <div class="item carousel-item active" data-bs-slide-number="0">
                                        <img class="blur-up lazyload" data-src="<?php echo e($main_image); ?>"
                                            src="<?php echo e($main_image); ?>" alt="<?php echo e($product[0]->name); ?>"
                                            title="<?php echo e($product[0]->name); ?>" width="625" height="808" />
                                    </div>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(count($product[0]->other_images) >= 1): ?>
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $product[0]->other_images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $images): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php
                                                $images = app(MediaService::class)->dynamic_image($images, 800);
                                            ?>
                                            <div class="item carousel-item" data-bs-slide-number="<?php echo e($key + 1); ?>">
                                                <img class="blur-up lazyload" data-src="<?php echo e($images); ?>"
                                                    src="<?php echo e($images); ?>" alt="<?php echo e($product[0]->name); ?>"
                                                    title="<?php echo e($product[0]->name); ?>" width="625" height="808" />
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </div>
                                <div class="model-thumbnail-img">
                                    <!-- Thumbnail slide -->
                                    <div class="carousel-indicators list-inline">
                                        <div class="list-inline-item active" id="carousel-selector-0"
                                            data-bs-slide-to="0" data-bs-target="#quickView">
                                            <?php
                                                $main_image = app(MediaService::class)->dynamic_image($product[0]->image, 200);
                                            ?>
                                            <img class="blur-up lazyload" data-src="<?php echo e($main_image); ?>"
                                                src="<?php echo e($main_image); ?>" alt="<?php echo e($product[0]->name); ?>"
                                                title="<?php echo e($product[0]->name); ?>" width="625" height="808" />
                                        </div>
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(count($product[0]->other_images) >= 1): ?>
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $product[0]->other_images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $images): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php
                                                    $images = app(MediaService::class)->dynamic_image($images, 200);
                                                ?>
                                                <div class="list-inline-item" id="carousel-selector-1"
                                                    data-bs-slide-to="<?php echo e($key + 1); ?>" data-bs-target="#quickView">
                                                    <img class="blur-up lazyload" data-src="<?php echo e($images); ?>"
                                                        src="<?php echo e($images); ?>" alt="<?php echo e($product[0]->name); ?>"
                                                        title="<?php echo e($product[0]->name); ?>" width="625"
                                                        height="808" />
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </div>
                                    <!-- End Thumbnail slide -->
                                    <!-- Carousel arrow button -->
                                    <a class="carousel-control-prev carousel-arrow rounded-1" href="#quickView"
                                        data-bs-target="#quickView" data-bs-slide="prev"><i
                                            class="icon anm anm-angle-left-r"></i></a>
                                    <a class="carousel-control-next carousel-arrow rounded-1" href="#quickView"
                                        data-bs-target="#quickView" data-bs-slide="next"><i
                                            class="icon anm anm-angle-right-r"></i></a>
                                    <!-- End Carousel arrow button -->
                                </div>
                                <!-- End Thumbnail image -->
                            </div>
                            <!-- End Model Thumbnail -->
                            
                            <div class="text-center mt-3"><a
                                    href="<?php echo e(customUrl(($this->product_type != 'combo-product' ? 'products' : 'combo-products') . '/' . $product[0]->slug)); ?>"
                                    class="text-link"><?php echo e(labels('front_messages.view_more_details', 'View More Details')); ?></a>
                            </div>
                        </div>
                        <div class="col-12 col-sm-6 col-md-6 col-lg-6">
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(count($product[0]->tags) >= 1): ?>
                                <div class="mb-1">
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $product[0]->tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <a wire:navigate href="<?php echo e(customUrl('products/?tag=' . $tag)); ?>"
                                            class="text fw-500 border border-2 px-1 tag-filter"
                                            title="<?php echo $tag; ?>"><?php echo $tag; ?>

                                        </a>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </div>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            <div class="product-arrow d-flex justify-content-between">
                                <h2 class="product-title"><?php echo e($product[0]->name); ?></h2>
                            </div>
                            <div class="product-review mt-0 mb-2">
                                <div class="rating d-flex mb-10px">
                                    <input id="input-3-ltr-star-md" name="input-3-ltr-star-md"
                                        class="kv-ltr-theme-svg-star rating-loading d-none"
                                        value="<?php echo e($product[0]->rating); ?>" dir="ltr" data-size="xs"
                                        data-show-clear="false" data-show-caption="false" readonly>
                                    <div class="reviews ms-2"><a href="#"><?php echo e($product[0]->no_of_ratings); ?>

                                            <?php echo e(labels('front_messages.reviews', 'Reviews')); ?></a></div>
                                </div>
                                <div class="d-flex-center fs-5 fw-500 mb-10px">
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($product[0]->type == 'combo-product'): ?>
                                        <span class="price product_price" id="price">
                                            <?php echo e(app(CurrencyService::class)->currentCurrencyPrice($product[0]->special_price > 0 ? $product[0]->special_price : $product[0]->price, true)); ?>

                                        </span>
                                    <?php else: ?>
                                        <span class="price product_price" id="price">
                                            <?php echo e($product[0]->type != 'variable_product'
                                                ? ($product[0]->variants[0]['special_price'] == 0 || $product[0]->variants[0]['special_price'] == null
                                                    ? app(CurrencyService::class)->currentCurrencyPrice($product[0]->variants[0]['price'], true)
                                                    : app(CurrencyService::class)->currentCurrencyPrice($product[0]->variants[0]['special_price'], true))
                                                : ($product[0]->min_max_price['special_min_price'] == 0 || $product[0]->min_max_price['special_min_price'] == null
                                                    ? app(CurrencyService::class)->currentCurrencyPrice($product[0]->min_max_price['max_price'], true)
                                                    : app(CurrencyService::class)->currentCurrencyPrice($product[0]->min_max_price['special_min_price'], true) .
                                                        '-' .
                                                        app(CurrencyService::class)->currentCurrencyPrice($product[0]->min_max_price['special_max_price'], true))); ?>

                                        </span>
                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </div>
                                <?php
                                    if ($this->product_type != 'combo-product') {
                                        $category = fetchDetails(
                                            \App\Models\Category::class,
                                            ['id' => $product[0]->category_id],
                                            'slug',
                                        );
                                    }
                                ?>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($product[0]->product_type == 'digital_product'): ?>
                                    <p class="mb-10px" title="Digital Product"><ion-icon
                                            class="custom-icon fs-6 me-1"
                                            name="cube-outline"></ion-icon><?php echo e(labels('front_messages.digital_product', 'Digital Product')); ?>

                                    </p>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($this->product_type != 'combo-product'): ?>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!empty(app(TranslationService::class)->getDynamicTranslation(Brand::class, 'name', $product[0]->brand, $language_code))): ?>
                                        <a wire:navigate
                                            href="<?php echo e(customUrl('products?brand=' . $product[0]->brand_slug)); ?>"
                                            class="text-ellipsis mb-10px" title="<?php echo app(TranslationService::class)->getDynamicTranslation(Brand::class, 'name', $product[0]->brand, $language_code); ?>"><ion-icon
                                                class="custom-icon fs-6 me-1"
                                                name="medal-outline"></ion-icon><?php echo app(TranslationService::class)->getDynamicTranslation(Brand::class, 'name', $product[0]->brand, $language_code); ?>

                                        </a>
                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    <a wire:navigate
                                        href="<?php echo e(customUrl('categories/' . $category[0]->slug . '/products')); ?>"
                                        class="text-ellipsis mb-10px text-secondary"
                                        title="<?php echo app(TranslationService::class)->getDynamicTranslation(Category::class, 'name', $product[0]->category_id, $language_code); ?>"><ion-icon name="layers-outline"
                                            class="custom-icon fs-6 me-1"></ion-icon><?php echo app(TranslationService::class)->getDynamicTranslation(Category::class, 'name', $product[0]->category_id, $language_code); ?>

                                    </a>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                <hr class="light-hr" />
                                <div class="text-muted"><?php echo e($product[0]->short_description); ?></div>
                                <hr class="light-hr" />
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($this->product_type == 'combo-product'): ?>
                                    <h4 class="fw-600 mb-0">
                                        <?php echo e(labels('front_messages.products_included_in_combo', 'Products Included In Combo')); ?>

                                    </h4>
                                    <div class="table-responsive w-100 mt-n2">
                                        <table class="grouped-product-list group-table">
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $product[0]->product_details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php
                                                    $item_image = app(MediaService::class)->dynamic_image($item['image'], 200);
                                                ?>
                                                <tr class="grouped-product-list-item border-bottom">
                                                    <td class="product-thumb">
                                                        <div class="position-relative">
                                                            <img class="blur-up lazyload"
                                                                data-src="<?php echo e($item_image); ?>"
                                                                src="<?php echo e($item_image); ?>" alt="<?php echo e($item['name']); ?>"
                                                                title="" width="70" />
                                                        </div>
                                                    </td>
                                                    <td class="product-label px-3">
                                                        <div class="product-name fw-500 mb-2 text-ellipsis"><a
                                                                wire:navigate
                                                                href="<?php echo e(customUrl('products/' . $item['slug'])); ?>"><?php echo e($item['name']); ?></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        </table>
                                    </div>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                                <div class="product-options d-flex-wrap">
                                    <div class="product-swatches-option">
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $product[0]->attributes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attributes): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php
                                                $attribute_ids = explode(',', $attributes['ids']);
                                                $attribute_values = explode(',', $attributes['value']);
                                            ?>
                                            <div class="product-item swatches-size w-100 mb-4 swatch-1 option2"
                                                data-option-index="1">
                                                <label for=""
                                                    class="label d-flex align-items-center fw-500"><?php echo e($attributes['name']); ?>:</label>
                                                <ul class="variants-size size-swatches d-flex-center pt-1 clearfix">
                                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $attribute_values; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <li class="swatch x-large available p-1 toggleInput"
                                                            onclick="toggleInput(this)">
                                                            <input type="radio" class="swatchLbl attributes d-none"
                                                                data-bs-toggle="tooltip"
                                                                value="<?php echo e($attribute_ids[$key]); ?>"
                                                                data-bs-placement="top" title="<?php echo e($val); ?>"
                                                                id="variant-<?php echo e($attribute_ids[$key]); ?>"><?php echo e($val); ?></span>
                                                        </li>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                </ul>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </div>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($this->product_type != 'combo-product'): ?>
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $product[0]->variants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $variant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                       
                                            <input type="hidden" class="variants" name="variants_ids"
                                                data-image-index="" data-name=""
                                                value="<?php echo e($variant['attribute_value_ids']); ?>"
                                                data-id="<?php echo e($variant['id']); ?>" data-price="<?php echo e($variant['price']); ?>"
                                                data-special_price="<?php echo e($variant['special_price']); ?>" />
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                   

                                        <?php
                                            if ($this->product_type != 'combo-product') {
                                                if (count($product[0]->variants) <= 1) {
                                                    $variant_id = $product[0]->variants[0]['id'];
                                                } else {
                                                    $variant_id = '';
                                                }
                                            } else {
                                                $variant_id = $product[0]->id;
                                            }
                                        ?>
                                    <div class="button-action mt-2 ">
                                      <div class="qtyDetail text-end cart-qtyDetail d-none ">
                                          <div class="qtyField">
                                            <button class="qtyBtn minus" href="#;"><ion-icon
                                                name="remove-outline"></ion-icon></button>
                                                <input
                                                    type="number"
                                                    name="quantity"
                                                    class="product-form-input qty"
                                                    value="<?php echo e($product['minimum_order_quantity'] ?? 1); ?>"
                                                    min="<?php echo e($product['minimum_order_quantity'] ?? 1); ?>"
                                                    step="<?php echo e($product['quantity_step_size'] ?? 1); ?>"
                                                    max="<?php echo e(($product['total_allowed_quantity'] ?? 0) == 0 ? '' : $product['total_allowed_quantity']); ?>"
                                                    data-variant-id="<?php echo e($product[0]->variants[0]['id'] ?? ''); ?>"
                                                    data-variant-price="<?php echo e(app(CurrencyService::class)->currentCurrencyPrice($product['variants'][0]['special_price'] ?? 0)); ?>"
                                                    data-product-type="regular"
                                                />
                                                <button class="qtyBtn plus" href="#;"><ion-icon
                                                name="add-outline"></ion-icon></button>
                                         </div>
                                        </div>
                                        <div class="addtocart  addtocart-btn ms-3 fl-1">
                                            <button type="submit" name="add"
                                                class="btn product-cart-submit w-100 add_cart modal_add_cart"
                                                id="add_cart" onclick="add_cart(this)"
                                                data-product-variant-id="<?php echo e($variant_id); ?>"
                                                data-name='<?php echo e($product[0]->name); ?>'
                                                data-slug='<?php echo e($product[0]->slug); ?>'
                                                data-brand-name="<?php echo e(app(TranslationService::class)->getDynamicTranslation(Brand::class, 'name', optional($product[0])->brand, $language_code) ?? ''); ?>"
                                                data-image='<?php echo e($product[0]->image); ?>'
                                                data-product-type='<?php echo e($product[0]->type == 'combo-product' ? 'combo' : 'regular'); ?>'
                                                data-max='<?php echo e($product[0]->total_allowed_quantity); ?>'
                                                data-step='<?php echo e($product[0]->quantity_step_size); ?>'
                                                data-store-id='<?php echo e($product[0]->store_id); ?>'
                                                data-min='<?php echo e($product[0]->minimum_order_quantity); ?>'><span><?php echo e(labels('front_messages.add_to_cart', 'Add to cart')); ?></span></button>
                                        </div>

                                       
                                    </div>
                                </div>
                                <!-- Social Sharing -->
                                <div class="social-sharing share-icon d-flex-center mx-0 mt-3">
                                    <span class="sharing-lbl fw-500">Share :</span>
                                    <div class="shareon"
                                        data-url="<?php echo e(customUrl(($this->product_type != 'combo-product' ? 'products' : 'combo-products') . '/' . $product[0]->slug)); ?>">
                                        <a class="facebook"
                                            data-text="Take a Look at this <?php echo e($product[0]->name); ?> on <?php echo e($system_settings['app_name']); ?>"></a>
                                        <a class="whatsapp"
                                            data-text="Take a Look at this <?php echo e($product[0]->name); ?> on <?php echo e($system_settings['app_name']); ?>"></a>
                                        <a class="linkedin"
                                            data-text="Take a Look at this <?php echo e($product[0]->name); ?> on <?php echo e($system_settings['app_name']); ?>"></a>
                                    </div>
                                </div>
                                <!-- End Social Sharing -->
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </div>
    </div>
    <script>
        function toggleInput(liElement) {
            var inputElement = liElement.querySelector('input[type="radio"]');
            var siblings = Array.from(liElement.parentNode.children).filter(function(child) {
                return child !== liElement;
            });
            siblings.forEach(function(sibling) {
                sibling.classList.remove("active");
            });
            if (inputElement) {
                inputElement.click();
                liElement.classList.add("active");
            }
        }
    </script>
<?php /**PATH /home/solarmar/solarmart-web.neuromonk.co.in/resources/views/components/utility/others/quickview-model.blade.php ENDPATH**/ ?>